Attribute VB_Name = "eqmodvector"
'---------------------------------------------------------------------
' Copyright  2006 Raymund Sarmiento
'
' Permission is hereby granted to use this Software for any purpose
' including combining with commercial products, creating derivative
' works, and redistribution of source or binary code, without
' limitation or consideration. Any redistributed copies of this
' Software must include the above Copyright Notice.
'
' THIS SOFTWARE IS PROVIDED "AS IS". THE AUTHOR OF THIS CODE MAKES NO
' WARRANTIES REGARDING THIS SOFTWARE, EXPRESS OR IMPLIED, AS TO ITS
' SUITABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
'---------------------------------------------------------------------
'
' EQMODVECTOR.BAS - Matrix Transformation Routines for 3-Star Alignment
'
' Written:  10-Dec-06   Raymund Sarmiento
'
' Edits:
'
' When      Who     What
' --------- ---     --------------------------------------------------
' 10-Dec-06 rcs     Initial edit for EQ Mount 3-Star Matrix Transformation
' 14-Dec-06 rcs     Added Taki Method on top of Affine Mapping Method for Comparison
'                   Taki Routines based on John Archbold's Excel computation
' 08-Apr-07 rcs     N-star implementation
'---------------------------------------------------------------------
'
'
'  SYNOPSIS:
'
'  This is a demonstration of the 3-Star Alignment Algorithm for the EQContrl.DLL
'
'  The EQ6CONTRL.DLL simplifies execution of the Mount controller board stepper
'  commands.
'
'  The mount circuitry needs to be modified for this test program to work.
'  Circuit details can be found at http://www.freewebs.com/eq6mod/
'

'  DISCLAIMER:

'  You can use the information on this site COMPLETELY AT YOUR OWN RISK.
'  The modification steps and other information on this site is provided
'  to you "AS IS" and WITHOUT WARRANTY OF ANY KIND, express, statutory,
'  implied or otherwise, including without limitation any warranty of
'  merchantability or fitness for any particular or intended purpose.
'  In no event the author will  be liable for any direct, indirect,
'  punitive, special, incidental or consequential damages or loss of any
'  kind whether or not the author  has been advised of the possibility
'  of such loss.

'  WARNING:

'  Circuit modifications implemented on your setup could invalidate
'  any warranty that you may have with your product. Use this
'  information at your own risk. The modifications involve direct
'  access to the stepper motor controls of your mount. Any "mis-control"
'  or "mis-command"  / "invalid parameter" or "garbage" data sent to the
'  mount could accidentally activate the stepper motors and allow it to
'  rotate "freely" damaging any equipment connected to your mount.
'  It is also possible that any garbage or invalid data sent to the mount
'  could cause its firmware to generate mis-steps pulse sequences to the
'  motors causing it to overheat. Make sure that you perform the
'  modifications and testing while there is no physical "load" or
'  dangling wires on your mount. Be sure to disconnect the power once
'  this event happens or if you notice any unusual sound coming from
'  the motor assembly.
'


Option Explicit


Public Type Matrix
    Element(1 To 3, 1 To 3) As Double    '2D array of elements
End Type

Public Type Matrix2
    Element(1 To 4, 1 To 4) As Double    '2D array of elements
End Type




Public Type Coord
 x As Double           'x = X Coordinate
 y As Double           'y = Y Coordinate
 z As Double
End Type


Public Type Coordt
 x As Double           'x = X Coordinate
 y As Double           'y = Y Coordinate
 z As Double
 f As Integer
End Type

Public Type CartesCoord
 x As Double           'x = X Coordinate
 y As Double           'y = Y Coordinate
 r As Double           ' Radius Sign
 RA As Double          ' Radius Alpha
End Type

Public Type SphereCoord
 x As Double           'x = X Coordinate
 y As Double           'y = Y Coordinate
 r As Double           'r = RA Range Flag
End Type


'Define Affine Matrix

Public EQMP As Matrix
Public EQMQ As Matrix

Public EQMI As Matrix
Public EQMM As Matrix
Public EQCO As Coord


'Define Taki Matrix

Public EQLMN1 As Matrix
Public EQLMN2 As Matrix

Public EQMI_T As Matrix
Public EQMT As Matrix
Public EQCT As Coord




'Function to put coordinate values into a LMN/lmn matrix array

Public Function GETLMN(ByRef p1 As Coord, ByRef p2 As Coord, ByRef p3 As Coord) As Matrix

Dim temp As Matrix
Dim UnitVect As Matrix

    With temp
    
        .Element(1, 1) = p2.x - p1.x
        .Element(2, 1) = p3.x - p1.x
        
        .Element(1, 2) = p2.y - p1.y
        .Element(2, 2) = p3.y - p1.y
        
        .Element(1, 3) = p2.z - p1.z
        .Element(2, 3) = p3.z - p1.z
            
    End With


    With UnitVect
    
        .Element(1, 1) = (temp.Element(1, 2) * temp.Element(2, 3)) - (temp.Element(1, 3) * temp.Element(2, 2))
        .Element(1, 2) = (temp.Element(1, 3) * temp.Element(2, 1)) - (temp.Element(1, 1) * temp.Element(2, 3))
        .Element(1, 3) = (temp.Element(1, 1) * temp.Element(2, 2)) - (temp.Element(1, 2) * temp.Element(2, 1))
        .Element(2, 1) = .Element(1, 1) ^ 2 + .Element(1, 2) ^ 2 + .Element(1, 3) ^ 2
        .Element(2, 2) = Sqr(.Element(2, 1))
        If .Element(2, 2) <> 0 Then .Element(2, 3) = 1 / .Element(2, 2)
        
    End With

    With temp
    
        .Element(3, 1) = UnitVect.Element(2, 3) * UnitVect.Element(1, 1)
        .Element(3, 2) = UnitVect.Element(2, 3) * UnitVect.Element(1, 2)
        .Element(3, 3) = UnitVect.Element(2, 3) * UnitVect.Element(1, 3)
   
    End With



    GETLMN = temp
    
End Function

'Function to put coordinate values into a P/Q Affine matrix array

Public Function GETPQ(ByRef p1 As Coord, ByRef p2 As Coord, ByRef p3 As Coord) As Matrix

Dim temp As Matrix

    With temp
        .Element(1, 1) = p2.x - p1.x
        .Element(2, 1) = p3.x - p1.x
        .Element(1, 2) = p2.y - p1.y
        .Element(2, 2) = p3.y - p1.y
    End With

    GETPQ = temp
    
End Function

' Subroutine to draw the Transformation Matrix (Taki Method)

Public Function EQ_AssembleMatrix_Taki(x As Double, y As Double, ByRef a1 As Coord, ByRef a2 As Coord, ByRef a3 As Coord, ByRef m1 As Coord, ByRef m2 As Coord, ByRef m3 As Coord) As Integer


Dim Det As Double
    
     
    ' Get the LMN Matrix

    EQLMN1 = GETLMN(a1, a2, a3)
    
    ' Get the lmn Matrix
    
    EQLMN2 = GETLMN(m1, m2, m3)

   
    
    With EQLMN1
    
        ' Get the Determinant
        
        Det = .Element(1, 1) * ((.Element(2, 2) * .Element(3, 3)) - (.Element(3, 2) * .Element(2, 3)))
        Det = Det - (.Element(1, 2) * ((.Element(2, 1) * .Element(3, 3)) - (.Element(3, 1) * .Element(2, 3))))
        Det = Det + (.Element(1, 3) * ((.Element(2, 1) * .Element(3, 2)) - (.Element(3, 1) * .Element(2, 2))))
        
        
        ' Compute for the Matrix Inverse of EQLMN1
        
        If Det = 0 Then
            err.Raise 999, "AssembleMatrix", "Cannot invert matrix with Determinant = 0"
        Else
    
            EQMI_T.Element(1, 1) = ((.Element(2, 2) * .Element(3, 3)) - (.Element(3, 2) * .Element(2, 3))) / Det
            EQMI_T.Element(1, 2) = ((.Element(1, 3) * .Element(3, 2)) - (.Element(1, 2) * .Element(3, 3))) / Det
            EQMI_T.Element(1, 3) = ((.Element(1, 2) * .Element(2, 3)) - (.Element(2, 2) * .Element(1, 3))) / Det
            EQMI_T.Element(2, 1) = ((.Element(2, 3) * .Element(3, 1)) - (.Element(3, 3) * .Element(2, 1))) / Det
            EQMI_T.Element(2, 2) = ((.Element(1, 1) * .Element(3, 3)) - (.Element(3, 1) * .Element(1, 3))) / Det
            EQMI_T.Element(2, 3) = ((.Element(1, 3) * .Element(2, 1)) - (.Element(2, 3) * .Element(1, 1))) / Det
            EQMI_T.Element(3, 1) = ((.Element(2, 1) * .Element(3, 2)) - (.Element(3, 1) * .Element(2, 2))) / Det
            EQMI_T.Element(3, 2) = ((.Element(1, 2) * .Element(3, 1)) - (.Element(3, 2) * .Element(1, 1))) / Det
            EQMI_T.Element(3, 3) = ((.Element(1, 1) * .Element(2, 2)) - (.Element(2, 1) * .Element(1, 2))) / Det
        End If
    
    End With
   
   
    ' Get the M Matrix by Multiplying EQMI and EQLMN2
    ' EQMI_T - Matrix A
    ' EQLMN2 - Matrix B
        
    
    EQMT.Element(1, 1) = (EQMI_T.Element(1, 1) * EQLMN2.Element(1, 1)) + (EQMI_T.Element(1, 2) * EQLMN2.Element(2, 1)) + (EQMI_T.Element(1, 3) * EQLMN2.Element(3, 1))
    EQMT.Element(1, 2) = (EQMI_T.Element(1, 1) * EQLMN2.Element(1, 2)) + (EQMI_T.Element(1, 2) * EQLMN2.Element(2, 2)) + (EQMI_T.Element(1, 3) * EQLMN2.Element(3, 2))
    EQMT.Element(1, 3) = (EQMI_T.Element(1, 1) * EQLMN2.Element(1, 3)) + (EQMI_T.Element(1, 2) * EQLMN2.Element(2, 3)) + (EQMI_T.Element(1, 3) * EQLMN2.Element(3, 3))
    
    EQMT.Element(2, 1) = (EQMI_T.Element(2, 1) * EQLMN2.Element(1, 1)) + (EQMI_T.Element(2, 2) * EQLMN2.Element(2, 1)) + (EQMI_T.Element(2, 3) * EQLMN2.Element(3, 1))
    EQMT.Element(2, 2) = (EQMI_T.Element(2, 1) * EQLMN2.Element(1, 2)) + (EQMI_T.Element(2, 2) * EQLMN2.Element(2, 2)) + (EQMI_T.Element(2, 3) * EQLMN2.Element(3, 2))
    EQMT.Element(2, 3) = (EQMI_T.Element(2, 1) * EQLMN2.Element(1, 3)) + (EQMI_T.Element(2, 2) * EQLMN2.Element(2, 3)) + (EQMI_T.Element(2, 3) * EQLMN2.Element(3, 3))
    
    EQMT.Element(3, 1) = (EQMI_T.Element(3, 1) * EQLMN2.Element(1, 1)) + (EQMI_T.Element(3, 2) * EQLMN2.Element(2, 1)) + (EQMI_T.Element(3, 3) * EQLMN2.Element(3, 1))
    EQMT.Element(3, 2) = (EQMI_T.Element(3, 1) * EQLMN2.Element(1, 2)) + (EQMI_T.Element(3, 2) * EQLMN2.Element(2, 2)) + (EQMI_T.Element(3, 3) * EQLMN2.Element(3, 2))
    EQMT.Element(3, 3) = (EQMI_T.Element(3, 1) * EQLMN2.Element(1, 3)) + (EQMI_T.Element(3, 2) * EQLMN2.Element(2, 3)) + (EQMI_T.Element(3, 3) * EQLMN2.Element(3, 3))
    
        
    ' Get the Coordinate Offset Vector and store it at EQCO Matrix

    EQCT.x = m1.x - ((a1.x * EQMT.Element(1, 1)) + (a1.y * EQMT.Element(2, 1)) + (a1.z * EQMT.Element(3, 1)))
    EQCT.y = m1.y - ((a1.x * EQMT.Element(1, 2)) + (a1.y * EQMT.Element(2, 2)) + (a1.z * EQMT.Element(3, 2)))
    EQCT.z = m1.z - ((a1.x * EQMT.Element(1, 3)) + (a1.y * EQMT.Element(2, 3)) + (a1.z * EQMT.Element(3, 3)))
    
    
     If (x + y) = 0 Then
        EQ_AssembleMatrix_Taki = 0
     Else
        EQ_AssembleMatrix_Taki = EQ_CheckPoint_in_Triangle(x, y, a1.x, a1.y, a2.x, a2.y, a3.x, a3.y)
'        HC.Label23.Caption = EQ_CheckPoint_in_Triangle(x, y, a1.x, a1.y, a2.x, a2.y, a3.x, a3.y)
     End If
    

End Function


'Function to transform the Coordinates (Taki Method)  using the MT Matrix and Offset Vector

Public Function EQ_Transform_Taki(ByRef ob As Coord) As Coord

    ' CoordTransform = Offset + CoordObject * Matrix MT

    EQ_Transform_Taki.x = EQCT.x + ((ob.x * EQMT.Element(1, 1)) + (ob.y * EQMT.Element(2, 1)) + (ob.z * EQMT.Element(3, 1)))
    EQ_Transform_Taki.y = EQCT.y + ((ob.x * EQMT.Element(1, 2)) + (ob.y * EQMT.Element(2, 2)) + (ob.z * EQMT.Element(3, 2)))
    EQ_Transform_Taki.z = EQCT.z + ((ob.x * EQMT.Element(1, 3)) + (ob.y * EQMT.Element(2, 3)) + (ob.z * EQMT.Element(3, 3)))


End Function

' Subroutine to draw the Transformation Matrix (Affine Mapping Method)

Public Function EQ_AssembleMatrix_Affine(x As Double, y As Double, ByRef a1 As Coord, ByRef a2 As Coord, ByRef a3 As Coord, ByRef m1 As Coord, ByRef m2 As Coord, ByRef m3 As Coord) As Integer


Dim Det As Double



    ' Get the P Matrix

    EQMP = GETPQ(a1, a2, a3)
    
    ' Get the Q Matrix
    
    EQMQ = GETPQ(m1, m2, m3)

    ' Get the Inverse of P
    
    With EQMP

        ' Get the EQMP Determinant for Inverse Computation

        Det = (.Element(1, 1) * .Element(2, 2)) - (.Element(1, 2) * .Element(2, 1))


        ' Make sure Determinant is NON ZERO

        If Det = 0 Then
            err.Raise 999, "AssembleMatrix", "Cannot invert matrix with Determinant = 0"
        Else
 
            'Perform the Matrix Inversion, put result to EQMI matrix
 
            EQMI.Element(1, 1) = (.Element(2, 2)) / Det
            EQMI.Element(1, 2) = (-.Element(1, 2)) / Det
            EQMI.Element(2, 1) = (-.Element(2, 1)) / Det
            EQMI.Element(2, 2) = (.Element(1, 1)) / Det

        End If
   
    End With
   
    ' Get the M Matrix by Multiplying EQMI and EQMQ
    ' EQMI - Matrix A
    ' EQMQ - Matrix B
        
    EQMM.Element(1, 1) = (EQMI.Element(1, 1) * EQMQ.Element(1, 1)) + (EQMI.Element(1, 2) * EQMQ.Element(2, 1))
    EQMM.Element(1, 2) = (EQMI.Element(1, 1) * EQMQ.Element(1, 2)) + (EQMI.Element(1, 2) * EQMQ.Element(2, 2))
    EQMM.Element(2, 1) = (EQMI.Element(2, 1) * EQMQ.Element(1, 1)) + (EQMI.Element(2, 2) * EQMQ.Element(2, 1))
    EQMM.Element(2, 2) = (EQMI.Element(2, 1) * EQMQ.Element(1, 2)) + (EQMI.Element(2, 2) * EQMQ.Element(2, 2))
    
        
    ' Get the Coordinate Offset Vector and store it at EQCO Matrix

    EQCO.x = m1.x - ((a1.x * EQMM.Element(1, 1)) + (a1.y * EQMM.Element(2, 1)))
    EQCO.y = m1.y - ((a1.x * EQMM.Element(1, 2)) + (a1.y * EQMM.Element(2, 2)))



     If (x + y) = 0 Then
        EQ_AssembleMatrix_Affine = 0
     Else
        EQ_AssembleMatrix_Affine = EQ_CheckPoint_in_Triangle(x, y, m1.x, m1.y, m2.x, m2.y, m3.x, m3.y)
     End If

End Function


'Function to transform the Coordinates (Affine Mapping) using the M Matrix and Offset Vector

Public Function EQ_Transform_Affine(ByRef ob As Coord) As Coord

    ' CoordTransform = Offset + CoordObject * Matrix M

    EQ_Transform_Affine.x = EQCO.x + ((ob.x * EQMM.Element(1, 1)) + (ob.y * EQMM.Element(2, 1)))
    EQ_Transform_Affine.y = EQCO.y + ((ob.x * EQMM.Element(1, 2)) + (ob.y * EQMM.Element(2, 2)))

End Function

'Function to convert spherical coordinates to Cartesian using the Coord structure

Public Function EQ_sp2Cs(ByRef obj As Coord) As Coord

Dim tmpobj As CartesCoord
Dim tmpobj4 As SphereCoord

    If HC.PolarEnable.Value = 1 Then
    
        tmpobj4 = EQ_SphericalPolar(obj.x, obj.y, gTot_step, RAEncoder_Home_pos, gDECEncoder_Home_pos, gLatitude)

        tmpobj = EQ_Polar2Cartes(tmpobj4.x, tmpobj4.y, gTot_step, RAEncoder_Home_pos, gDECEncoder_Home_pos)
    
        EQ_sp2Cs.x = tmpobj.x
        EQ_sp2Cs.y = tmpobj.y
        EQ_sp2Cs.z = 1
    Else
        EQ_sp2Cs.x = obj.x
        EQ_sp2Cs.y = obj.y
        EQ_sp2Cs.z = 1
    End If
    
End Function

'Function to convert polar coordinates to Cartesian using the Coord structure


Public Function EQ_pl2Cs(ByRef obj As Coord) As Coord

Dim tmpobj As CartesCoord

    If HC.PolarEnable.Value = 1 Then
        tmpobj = EQ_Polar2Cartes(obj.x, obj.y, gTot_step, RAEncoder_Home_pos, gDECEncoder_Home_pos)
    
        EQ_pl2Cs.x = tmpobj.x
        EQ_pl2Cs.y = tmpobj.y
        EQ_pl2Cs.z = 1
    Else
        EQ_pl2Cs.x = obj.x
        EQ_pl2Cs.y = obj.y
        EQ_pl2Cs.z = 1
    End If
    
End Function

'Implement an Affine transformation on a Polar coordinate system
'This is done by converting the Polar Data to Cartesian, Apply affine transformation
'Then restore the transformed Cartesian Coordinates back to polar


Public Function EQ_plAffine(ByRef obj As Coord) As Coord

Dim tmpobj1 As CartesCoord
Dim tmpobj2 As Coord
Dim tmpobj3 As Coord
Dim tmpobj4 As SphereCoord

       If HC.PolarEnable.Value = 1 Then
            tmpobj4 = EQ_SphericalPolar(obj.x, obj.y, gTot_step, RAEncoder_Home_pos, gDECEncoder_Home_pos, gLatitude)

            tmpobj1 = EQ_Polar2Cartes(tmpobj4.x, tmpobj4.y, gTot_step, RAEncoder_Home_pos, gDECEncoder_Home_pos)
    
            tmpobj2.x = tmpobj1.x
            tmpobj2.y = tmpobj1.y
            tmpobj2.z = 1
    
            tmpobj3 = EQ_Transform_Affine(tmpobj2)
    
            tmpobj2 = EQ_Cartes2Polar(tmpobj3.x, tmpobj3.y, tmpobj1.r, tmpobj1.RA, gTot_step, RAEncoder_Home_pos, gDECEncoder_Home_pos)

            EQ_plAffine = EQ_PolarSpherical(tmpobj2.x, tmpobj2.y, gTot_step, RAEncoder_Home_pos, gDECEncoder_Home_pos, gLatitude, tmpobj4.r)

        Else
            tmpobj3 = EQ_Transform_Affine(obj)
            EQ_plAffine.x = tmpobj3.x
            EQ_plAffine.y = tmpobj3.y
            EQ_plAffine.z = 1
        End If

End Function


Public Function EQ_plAffine2(ByRef obj As Coord) As Coord

Dim tmpobj1 As CartesCoord
Dim tmpobj2 As Coord
Dim tmpobj3 As Coord
Dim tmpobj4 As SphereCoord

       If HC.PolarEnable.Value = 1 Then
            tmpobj4 = EQ_SphericalPolar(obj.x, obj.y, gTot_step, RAEncoder_Home_pos, gDECEncoder_Home_pos, gLatitude)

            tmpobj1 = EQ_Polar2Cartes(tmpobj4.x, tmpobj4.y, gTot_step, RAEncoder_Home_pos, gDECEncoder_Home_pos)
    
            tmpobj2.x = tmpobj1.x
            tmpobj2.y = tmpobj1.y
            tmpobj2.z = 1
    
            tmpobj3 = EQ_Transform_Affine(tmpobj2)
    
            tmpobj2 = EQ_Cartes2Polar(tmpobj3.x, tmpobj3.y, tmpobj1.r, tmpobj1.RA, gTot_step, RAEncoder_Home_pos, gDECEncoder_Home_pos)


            EQ_plAffine2 = EQ_PolarSpherical(tmpobj2.x, tmpobj2.y, gTot_step, RAEncoder_Home_pos, gDECEncoder_Home_pos, gLatitude, tmpobj4.r)

        Else
            tmpobj3 = EQ_Transform_Affine(obj)
            EQ_plAffine2.x = tmpobj3.x
            EQ_plAffine2.y = tmpobj3.y
            EQ_plAffine2.z = 1
        End If

End Function
'Implement a TAKI transformation on a Polar coordinate system
'This is done by converting the Polar Data to Cartesian, Apply TAKI transformation
'Then restore the transformed Cartesian Coordinates back to polar

Public Function EQ_plTaki(ByRef obj As Coord) As Coord

Dim tmpobj1 As CartesCoord
Dim tmpobj2 As Coord
Dim tmpobj3 As Coord
Dim tmpobj4 As SphereCoord

    If HC.PolarEnable.Value = 1 Then
        tmpobj4 = EQ_SphericalPolar(obj.x, obj.y, gTot_step, RAEncoder_Home_pos, gDECEncoder_Home_pos, gLatitude)
        tmpobj1 = EQ_Polar2Cartes(tmpobj4.x, tmpobj4.y, gTot_step, RAEncoder_Home_pos, gDECEncoder_Home_pos)
    
        tmpobj2.x = tmpobj1.x
        tmpobj2.y = tmpobj1.y
        tmpobj2.z = 1
   
        tmpobj3 = EQ_Transform_Taki(tmpobj2)
        
        tmpobj2 = EQ_Cartes2Polar(tmpobj3.x, tmpobj3.y, tmpobj1.r, tmpobj1.RA, gTot_step, RAEncoder_Home_pos, gDECEncoder_Home_pos)
    
        EQ_plTaki = EQ_PolarSpherical(tmpobj2.x, tmpobj2.y, gTot_step, RAEncoder_Home_pos, gDECEncoder_Home_pos, gLatitude, tmpobj4.r)

    Else
        tmpobj3 = EQ_Transform_Taki(obj)
        EQ_plTaki.x = tmpobj3.x
        EQ_plTaki.y = tmpobj3.y
        EQ_plTaki.z = 1
    End If

End Function

' Function to Convert Polar RA/DEC Stepper coordinates to Cartesian Coordinates

Public Function EQ_Polar2Cartes(RA As Double, DEC As Double, TOT As Double, RACENTER As Double, DECCENTER As Double) As CartesCoord


Dim x2 As Double
Dim y2 As Double

Dim theta As Double
Dim radius As Double

Dim angle As Double
Dim radiusder As Double
Dim i As Double

Dim radpeak As Double


    ' make angle stays within the 360 bound

    If RA > RACENTER Then
        i = ((RA - RACENTER) / TOT) * 360
    Else
        i = ((RACENTER - RA) / TOT) * 360
        i = 360 - i
    End If
    
    theta = Range360(i) * DEG_RAD

    'treat y as the radius of the polar coordinate

    radius = DEC - DECCENTER

    radpeak = 0
    
  '  Removed
    
  '  If Abs(radius) > DECPEAK Then
  '      radpeak = radius
  '      If radius > 0 Then
  '          radius = (2 * DECPEAK) - radius
  '      Else
  '          radius = ((2 * DECPEAK) + radius) * -1
  '      End If
  '      radpeak = radpeak - radius
  '  End If


    ' Avoid division 0 errors
    
    If radius = 0 Then radius = 1
    
  ' Get the cartesian coordinates
    
    EQ_Polar2Cartes.x = Cos(theta) * radius
    EQ_Polar2Cartes.y = Sin(theta) * radius
    EQ_Polar2Cartes.RA = radpeak
    
  ' if radius is a negative number, pass this info on the next conversion routine
    
    If radius > 0 Then
        EQ_Polar2Cartes.r = 1
    Else
        EQ_Polar2Cartes.r = -1
    End If

End Function

'Function to convert the Cartesian Coordinate data back to RA/DEC polar

Public Function EQ_Cartes2Polar(x As Double, y As Double, r As Double, RA As Double, TOT As Double, RACENTER As Double, DECCENTER As Double) As Coord

Dim radiusder As Double
Dim angle As Double

    ' Ah the famous radius formula

    radiusder = Sqr((x * x) + (y * y)) * r
    
    
    ' And the nasty angle compute routine (any simpler way to impelent this ?)
    
    angle = 0
    If x > 0 Then angle = Atn(y / x)
    If x < 0 Then
        If y >= 0 Then
          angle = Atn(y / x) + PI
          
        Else
          angle = Atn(y / x) - PI
        End If
    End If
    If x = 0 Then
        If y > 0 Then
            angle = PI / 2
        Else
            angle = -1 * (PI / 2)
        End If
    End If
    
    ' Convert angle to degrees
    
    angle = angle * RAD_DEG
   
    If angle < 0 Then angle = 360 + angle
    
    If r < 0 Then angle = Range360(angle + 180)
    
    If (angle > 180) Then
            EQ_Cartes2Polar.x = RACENTER - (((360 - angle) / 360) * TOT)
        Else
            EQ_Cartes2Polar.x = ((angle / 360) * TOT) + RACENTER
    End If
    
    'treat y as the polar coordinate radius (ra var not used - always 0)
    
    EQ_Cartes2Polar.y = radiusder + DECCENTER + RA
    
End Function

Public Function EQ_UpdateTaki(x As Double, y As Double) As Integer

Dim i As Long
Dim j As Long
Dim k As Long
Dim tmpcoord As Coord

Dim datholder(1 To MAX_STARS) As Double
Dim dotidholder(1 To MAX_STARS) As Double


    ' Adjust only if there are four alignment stars
    
    If gAlignmentStars_count < 3 Then Exit Function


    tmpcoord.x = x
    tmpcoord.y = y

    For i = 1 To gAlignmentStars_count
         ' Compute for total X-Y distance.
         
          If HC.PierStrict.Value = 1 Then
            datholder(i) = Abs(my_Points(i).x - x) + Abs(my_Points(i).y - y)
          Else
            datholder(i) = Abs(EQ_sp2Cs(my_Points(i)).x - EQ_sp2Cs(tmpcoord).x) + Abs(EQ_sp2Cs(my_Points(i)).y - EQ_sp2Cs(tmpcoord).y)
          End If
          
         ' Also save the reference star id for this particular reference star
         dotidholder(i) = i
    Next i
    Call EQ_Quicksort(datholder(), dotidholder(), 1, gAlignmentStars_count)
    ' Get the nearest Star (lowest at the head of the sorted list)
    i = dotidholder(1)
    j = dotidholder(2)
    k = dotidholder(3)
    
    
    gTaki1 = i
    gTaki2 = j
    gTaki3 = k
    
    EQ_UpdateTaki = EQ_AssembleMatrix_Taki(EQ_sp2Cs(tmpcoord).x, EQ_sp2Cs(tmpcoord).y, EQ_sp2Cs(ct_Points(i)), EQ_sp2Cs(ct_Points(j)), EQ_sp2Cs(ct_Points(k)), EQ_sp2Cs(my_Points(i)), EQ_sp2Cs(my_Points(j)), EQ_sp2Cs(my_Points(k)))

    
End Function

Public Function EQ_UpdateAffine(x As Double, y As Double) As Integer

Dim tmpcoord As Coord

Dim i As Long
Dim j As Long
Dim k As Long

Dim datholder(1 To MAX_STARS) As Double
Dim dotidholder(1 To MAX_STARS) As Double


    ' Adjust only if there are four alignment stars
    
    If gAlignmentStars_count < 3 Then Exit Function

    
    tmpcoord.x = x
    tmpcoord.y = y


    For i = 1 To gAlignmentStars_count
         ' Compute for total X-Y distance.
         
         If HC.PierStrict.Value = 1 Then
             datholder(i) = Abs(my_Points(i).x - x) + Abs(my_Points(i).y - y)
         Else
            datholder(i) = Abs(EQ_sp2Cs(my_Points(i)).x - EQ_sp2Cs(tmpcoord).x) + Abs(EQ_sp2Cs(my_Points(i)).y - EQ_sp2Cs(tmpcoord).y)
         End If
         
         ' Also save the reference star id for this particular reference star
         dotidholder(i) = i
    Next i
    Call EQ_Quicksort(datholder(), dotidholder(), 1, gAlignmentStars_count)
    ' Get the nearest Star (lowest at the head of the sorted list)
    i = dotidholder(1)
    j = dotidholder(2)
    k = dotidholder(3)
    

    
    gAffine1 = i
    gAffine2 = j
    gAffine3 = k
    
    EQ_UpdateAffine = EQ_AssembleMatrix_Affine(EQ_sp2Cs(tmpcoord).x, EQ_sp2Cs(tmpcoord).y, EQ_sp2Cs(my_Points(i)), EQ_sp2Cs(my_Points(j)), EQ_sp2Cs(my_Points(k)), EQ_sp2Cs(ct_Points(i)), EQ_sp2Cs(ct_Points(j)), EQ_sp2Cs(ct_Points(k)))
    
    
End Function

' Subroutine to implement an Array sort

Public Sub EQ_Quicksort(List() As Double, Sublist() As Double, min As Integer, max As Integer)

Dim med_value As Double
Dim submed As Double

Dim hi As Integer
Dim lo As Integer
Dim i As Integer


    If min >= max Then Exit Sub

    i = Int((max - min + 1) * Rnd + min)
    med_value = List(i)
    submed = Sublist(i)

    List(i) = List(min)
    Sublist(i) = Sublist(min)

    lo = min
    hi = max
    Do

        Do While List(hi) >= med_value
            hi = hi - 1
            If hi <= lo Then Exit Do
        Loop
        If hi <= lo Then
            List(lo) = med_value
            Sublist(lo) = submed
            Exit Do
        End If


        List(lo) = List(hi)
        Sublist(lo) = Sublist(hi)

        lo = lo + 1
        Do While List(lo) < med_value
            lo = lo + 1
            If lo >= hi Then Exit Do
        Loop
        If lo >= hi Then
            lo = hi
            List(hi) = med_value
            Sublist(hi) = submed
            Exit Do
        End If

        List(hi) = List(lo)
        Sublist(hi) = Sublist(lo)
    Loop

    EQ_Quicksort List(), Sublist(), min, lo - 1
    EQ_Quicksort List(), Sublist(), lo + 1, max
    
End Sub

' Function to compute for an area of a triangle

Public Function EQ_Triangle_Area(px1 As Double, py1 As Double, px2 As Double, py2 As Double, px3 As Double, py3 As Double) As Double

Dim ta As Double

'True formula is this
'    EQ_Triangle_Area = Abs(((px2 * py1) - (px1 * py2)) + ((px3 * py2) - (px2 * py3)) + ((px1 * py3) - (px3 * py1))) / 2

' Make LARGE  numerical value safe for Windows by adding a scaling factor

    ta = (((px2 * py1) - (px1 * py2)) / 10000) + (((px3 * py2) - (px2 * py3)) / 10000) + (((px1 * py3) - (px3 * py1)) / 10000)

    EQ_Triangle_Area = Abs(ta) / 2
    
End Function

' Function to check if a point is inside the triangle. Computed based sum of areas method

Public Function EQ_CheckPoint_in_Triangle(px As Double, py As Double, px1 As Double, py1 As Double, px2 As Double, py2 As Double, px3 As Double, py3 As Double) As Integer

Dim ta As Double
Dim t1 As Double
Dim t2 As Double
Dim t3 As Double

    ta = EQ_Triangle_Area(px1, py1, px2, py2, px3, py3)
    t1 = EQ_Triangle_Area(px, py, px2, py2, px3, py3)
    t2 = EQ_Triangle_Area(px1, py1, px, py, px3, py3)
    t3 = EQ_Triangle_Area(px1, py1, px2, py2, px, py)


    If Abs(ta - t1 - t2 - t3) < 2 Then
        EQ_CheckPoint_in_Triangle = 1
    Else
        EQ_CheckPoint_in_Triangle = 0
    End If

End Function




Public Function EQ_GetCenterPoint(p1 As Coord, p2 As Coord, p3 As Coord) As Coord

Dim p1x As Double
Dim p1y As Double
Dim p2x As Double
Dim p2y As Double
Dim p3x As Double
Dim p3y As Double
Dim p4x As Double
Dim p4y As Double

Dim XD1 As Double
Dim YD1 As Double
Dim XD2 As Double
Dim YD2 As Double
Dim XD3 As Double
Dim YD3 As Double

Dim ua As Double
Dim ub As Double
Dim dv As Double



' Get the two line 4 point data

    p1x = p1.x
    p1y = p1.y
    
    
    If p3.x > p2.x Then
        p2x = ((p3.x - p2.x) / 2) + p2.x
    Else
        p2x = ((p2.x - p3.x) / 2) + p3.x
    End If
    
    If p3.y > p2.y Then
        p2y = ((p3.y - p2.y) / 2) + p2.y
    Else
        p2y = ((p2.y - p3.y) / 2) + p3.y
    End If
    
    p3x = p2.x
    p3y = p2.y
    
    
    If p1.x > p3.x Then
        p4x = ((p1.x - p3.x) / 2) + p3.x
    Else
        p4x = ((p3.x - p1.x) / 2) + p1.x
    End If
    
    If p1.y > p3.y Then
        p4y = ((p1.y - p3.y) / 2) + p3.y
    Else
        p4y = ((p3.y - p1.y) / 2) + p1.y
    End If
    
    
    XD1 = p2x - p1x
    XD2 = p4x - p3x
    YD1 = p2y - p1y
    YD2 = p4y - p3y
    XD3 = p1x - p3x
    YD3 = p1y - p3y
    
   
    dv = (YD2 * XD1) - (XD2 * YD1)
    
    If dv = 0 Then dv = 0.00000001   'avoid div 0 errors
    
    
    ua = ((XD2 * YD3) - (YD2 * XD3)) / dv
    ub = ((XD1 * YD3) - (YD1 * XD3)) / dv
    
    EQ_GetCenterPoint.x = p1x + (ua * XD1)
    EQ_GetCenterPoint.y = p1y + (ub * YD1)
    
End Function


Public Function EQ_SphericalPolar(RA As Double, DEC As Double, TOT As Double, RACENTER As Double, DECCENTER As Double, Latitude As Double) As SphereCoord
Dim i As Double
Dim j As Double
Dim x As Double
Dim y As Double


    
    
    i = Get_EncoderHours(RACENTER, RA, TOT, 0)
    j = Get_EncoderDegrees(DECCENTER, DEC, TOT, 0) + 270
    j = Range360(j)
  
    Call hadec_aa(Latitude * DEG_RAD, i * HRS_RAD, j * DEG_RAD, y, x)
   
    EQ_SphericalPolar.x = ((((x * RAD_DEG) - 180) / 360) * TOT) + RACENTER
    EQ_SphericalPolar.y = ((((y * RAD_DEG) + 90) / 180) * TOT) + DECCENTER
    
    
    ' Check if RA value is within allowed visible range
    
    i = TOT / 4
    If (RA <= (RACENTER + i)) And (RA >= (RACENTER - i)) Then
        EQ_SphericalPolar.r = 1
    Else
        EQ_SphericalPolar.r = 0
    End If


End Function

Public Function EQ_PolarSpherical(RA As Double, DEC As Double, TOT As Double, RACENTER As Double, DECCENTER As Double, Latitude As Double, range As Double) As Coord
Dim i As Double
Dim j As Double
Dim x As Double
Dim y As Double
Dim pr As Double


    i = (((RA - RACENTER) / TOT) * 360) + 180
    j = (((DEC - DECCENTER) / TOT) * 180) - 90

    Call aa_hadec(Latitude * DEG_RAD, j * DEG_RAD, i * DEG_RAD, x, y)
    
    If i > 180 Then
        
        If range = 0 Then
            y = Range360(180 - (y * RAD_DEG))
        Else
            y = Range360(y * RAD_DEG)
        End If
    Else
        
        If range = 0 Then
            y = Range360(y * RAD_DEG)
        Else
            y = Range360(180 - (y * RAD_DEG))
        End If
    End If
    
  j = Range360(y + 90)
    
  If j < 180 Then
    If range = 1 Then
        x = Range24(x * RAD_HRS)
    Else
        x = Range24(24 + (x * RAD_HRS))
    End If
  Else
        x = Range24(12 + (x * RAD_HRS))
  End If
    
     
  EQ_PolarSpherical.x = Get_EncoderfromHours(RACENTER, x, TOT, 0)
  EQ_PolarSpherical.y = Get_EncoderfromDegrees(DECCENTER, y + 90, TOT, 0, 0)
    
End Function


Public Function EQ_Spherical2Cartes(RA As Double, DEC As Double, TOT As Double, RACENTER As Double, DECCENTER As Double) As CartesCoord

Dim tmpobj1 As CartesCoord
Dim tmpobj4 As SphereCoord

        tmpobj4 = EQ_SphericalPolar(RA, DEC, TOT, RACENTER, DECCENTER, gLatitude)

        tmpobj1 = EQ_Polar2Cartes(tmpobj4.x, tmpobj4.y, TOT, RACENTER, DECCENTER)
    
        EQ_Spherical2Cartes.x = tmpobj1.x
        EQ_Spherical2Cartes.y = tmpobj1.y
        EQ_Spherical2Cartes.RA = tmpobj1.RA
        EQ_Spherical2Cartes.r = tmpobj1.r
        
    
End Function

Public Function EQ_Cartes2Spherical(x As Double, y As Double, r As Double, RA As Double, range As Double, TOT As Double, RACENTER As Double, DECCENTER As Double) As Coord
Dim tmpobj2 As Coord

    
        tmpobj2 = EQ_Cartes2Polar(x, y, r, RA, TOT, RACENTER, DECCENTER)

        EQ_Cartes2Spherical = EQ_PolarSpherical(tmpobj2.x, tmpobj2.y, gTot_step, RAEncoder_Home_pos, gDECEncoder_Home_pos, gLatitude, range)


End Function



