VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Telescope"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Description = "ASCOM Scope Driver Template"
'---------------------------------------------------------------------
' Copyright  2000-2002 SPACE.com Inc., New York, NY
'
' Permission is hereby granted to use this Software for any purpose
' including combining with commercial products, creating derivative
' works, and redistribution of source or binary code, without
' limitation or consideration. Any redistributed copies of this
' Software must include the above Copyright Notice.
'
' THIS SOFTWARE IS PROVIDED "AS IS". SPACE.COM, INC. MAKES NO
' WARRANTIES REGARDING THIS SOFTWARE, EXPRESS OR IMPLIED, AS TO ITS
' SUITABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
'---------------------------------------------------------------------
'   =============
'   TELESCOPE.CLS
'   =============
'
' Implementation of the ASCOM XXX driver Telescope interface
'
'   **********
'   ** NOTE **  CHANGE THE INFO IN THE PROJECT/MAKE TAB!
'   ** NOTE **  CHANGE THE ERR_SOURCE STRING!
'   ** NOTE **  CHANGE THE TELESCOPE OBJECT PROPERTIES IN OBJECT BROWSER!  <=== EVERYONE FORGETS THIS!!
'   ** NOTE **  CHANGE THE ID AND DESC STRINGS BELOW
'   **********
'
' Written:  27-Jun-00   Robert B. Denny <rdenny@dc3.com>
'
' Edits:
'
' When      Who     What
' --------- ---     --------------------------------------------------
' 27-Jun-00 rbd     Initial edit, for template project
' 21-Aug-00 rbd     Changed AlignmentModes enum to use 'alg' prefix
'                   and added algUnknown. Remove serial form and
'                   control. Add reference to DriverHelper for
'                   serial and utility stuff.
' 14-Oct-00 rbd     SlewSettleTime property
' 12-Nov-00 rbd     ByVal for all parameters and Lets - for JScript
' 13-Nov-00 rbd     Name and Description return String not Double,
'                   Park() does not take a command.
' 19-Nov-00 rbd     DriverInfo is a String.
' 21-Nov-00 rbd     Standardize DriverInfo to use VERS resource data.
' 13-Jan-01 rbd     Fill in missing ERR_SOURCE argument and specifics
'                   for calls to Err.Raise for "not implemented".
' 21-Jan-00 rbd     New Helper.Profile object, self-registration.
' 25-Jan-01 rbd     New properties CanSlew, CanSlewAsync, CanSync,
'                   CanPark, CanFindHome, CanSetPark, CanUnpark
'                   Interface V1.1
' 06-Feb-01 rbd     Add Tracking, CanSetTracking
' 08-Jun-01 rbd     New Profile.DeviceType to generalize Chooser and
'                   Profile.
' 08-Jun-01 rbd     Telescope 1.4: Add PulseGuide()
' 05-Oct-01 rbd     Add missing ByVals
' 27-Jul-02 rbd     ASCOm Platform 2.0
' 03-Sep-03 rbd     ASCOM Platform 3.0
' 24-Nov-04 rbd     ASCOM Platform 4.0 (Still V1 interface :-(( )
' 04-Nov-06 rcs     ASCOM EQMOD Driver modification
' 20-Nov-06 rcs     ASCOM Fix Elevation Registry Bug
' 01-Dec-06 rcs     Add GPS Function and Autoguider port save
' 01-Dec-06 rcs     Fix Autoguider port restore bug
' 11-Jan-07 rcs     Handle 0 duration errors
' 30-Jan-07 rcs     Activate SlewSettletime
' 01-Feb-07 rcs     Added Custom rate tracking
' 19-Mar-07 rcs     Initial Edit for Three star alignment
' 15-Aug-07 cs      Client Counting
' 30-Aug-07 cs      SyncRAMotor, SyncDECMotor added.
' 05-Oct-07 cs      PecMoveAxis added.
'---------------------------------------------------------------------

Option Explicit

Public Enum AlignmentModes
    algUnknown = -1
    algAltAz = 0
    algPolar = 1
    algGermanPolar = 2
End Enum

Public Enum GuideDirections
    guideNorth = 0
    guideSouth = 1
    guideEast = 2
    guideWest = 3
End Enum


Public Enum EquatorialCoordinateType
    equOther = 0
    equLocalTopocentric = 1
    equJ2000 = 2
    equJ2050 = 3
    equB1950 = 4
End Enum

Public Enum DriveRates
    driveSidereal = 0
    driveLunar = 1
    driveSolar = 2
    driveKing = 3
End Enum

Public Enum AxisID
    AxisPrimary = 0
    axisSecondary = 1
    axisTertiary = 2
End Enum

Public Enum PierSide
    pierUnknown = -1
    PierEast = 0
    PierWest = 1
End Enum

'Private Const id As String = "EQMOD.Telescope"
'Private Const DESC As String = "EQMOD ASCOM Scope Driver"

Private m_Serial As DriverHelper.Serial
Private m_Util As DriverHelper.Util
Private m_Profile As DriverHelper.Profile
Private m_iSettleTime As Integer

Private m_DriveRates As Collection




Private Sub Class_Initialize()

    If ClientCount = 0 Then
    
        eqres = EQ_End()
    
        Set m_Serial = New DriverHelper.Serial
        Set m_Util = New DriverHelper.Util
        Set m_Profile = New DriverHelper.Profile
        m_Profile.DeviceType = "Telescope"          ' We're a Telescope driver
        m_iSettleTime = 0                           ' Default 0 slew settle time
        m_Profile.Register ASCOM_id, ASCOM_DESC                 ' Self-register
        
        Set m_DriveRates = New Collection
        m_DriveRates.Add driveSidereal
        m_DriveRates.Add driveLunar
        m_DriveRates.Add driveSolar
        
        gHemisphere = 1
        gSidFlag = 1
        gTargetRA = EQ_INVALIDCOORDINATE
        gTargetDec = EQ_INVALIDCOORDINATE
        gEQTimeDelta = 0
        
        gTot_step = gDefault_step
        gEQ_MAXSYNC = EQ_MAXSYNC_Const
            
        
        'Initialize position values - They are actually done also on
        'Driver connect
        Call readSiderealRate
        Call ReadSiteValues
        Call ReadSyncMap
        Call ReadAlignMap
    
        
        gEQparkstatus = 0
        gTrackingStatus = 0                        ' Initially not tracking
        gDeclinationRate = 0
        gRightAscensionRate = 0
        
        Call readRALimit
        If gRA_Limit_East <> 0 Or gRA_Limit_West <> 0 Then
            ' Limiting is crrently enabled - use default limit until unpark
            ' on unpark custom limits are applied.
            gRA_Limit_East = &H5D5500                  ' Set RA Limit West Side
            gRA_Limit_West = &HA2AB00                  ' Set RA Limit East Side
        End If
        
        ' At least with an initial value
        
        gDECEncoder_Home_pos = DECEncoder_Home_pos_const
        
        
        gRAStatus = EQ_MOTORBUSY                   ' RA Motor Busy Status
        gDECStatus = EQ_MOTORBUSY                  ' DEC Motor Busy Status
        gSlewStatus = False                        ' Not Slewing status
        gRAStatus_slew = False                     ' Slew to track condidition
        gSlewCount = 0                             ' Goto Iterative Counter
        
        
        ' Initialize these values for polling emulation
        
        gEmulRA = 0
        gEmulDEC = 0
        gEmulOneShot = False
        gEmulNudge = False
        
        
        ReadComPortSettings
        
      
        gTot_RA = gTot_step                        ' Set RA Total Encoder Step Count
        gTot_DEC = gTot_step                       ' Set DEC total Encoder Step Count
        gRAWormSteps = 50133
        gDECWormSteps = 50133
        gRAWormPeriod = 480
        gSOP = 0                                    'Set at unknown pier setting
    
    
        HC.HCMessage.Text = ""                           'Set Message Center to BLANK
        HC.HCTextAlign.Text = ""
     
        HC.DisplayTimer.Enabled = True
    End If
    
    ClientCount = ClientCount + 1
    HC.Add_Message (HC.oLangDll.GetLangString(5134) & CStr(ClientCount - 1))
    
End Sub

Private Sub Class_Terminate()
    
    On Error Resume Next
    
    If ClientCount = 2 Then
    
        HC.DisplayTimer.Enabled = False
    
        If EQ_GetMountStatus() = 1 Then     ' We update only if the mount is online
            ' clients really should have disconnected via ASCOM prior to shutdown
            ' but if just in case they don't save the park status
            writeParkStatus gEQparkstatus
        End If
        
        eqres = EQ_End()
        
        writeratebarstateHC
        writeDriftVal
        writeRASyncCheckVal
        writePulseguidepwidth
        
        
        Unload HC
        Unload Align
        Unload Slewpad
        Unload GPSSetup
        Unload NStar_debug
        Unload StarEditform
        Unload JStickConfigForm
        ClientCount = 1
    Else
        ClientCount = ClientCount - 1
        HC.Add_Message (HC.oLangDll.GetLangString(5134) & CStr(ClientCount - 1))
    End If
    
End Sub

'------------------ V2 Compliance Properties

Public Property Get AlignmentMode() As AlignmentModes

    AlignmentMode = algGermanPolar
    
End Property

Public Property Get AtHome() As Boolean
    AtHome = False
End Property

Public Property Get AtPark() As Boolean

    If gEQparkstatus = 1 Then
        AtPark = True
    Else
        AtPark = False
    End If
    
End Property

'Later this will be changed to support the property

Public Property Get CanSetDeclinationRate() As Boolean
    CanSetDeclinationRate = True
End Property

'Later this will be changed to support the property
Public Property Get CanSetGuideRates() As Boolean
    CanSetGuideRates = False
End Property


Public Property Get CanSetPierSide() As Boolean
    CanSetPierSide = False
End Property

Public Property Get CanSetRightAscensionRate() As Boolean
    CanSetRightAscensionRate = True
End Property

Public Property Get CanSlewAltAz() As Boolean
    CanSlewAltAz = False
End Property

Public Property Get CanSlewAltAzAsync() As Boolean
    CanSlewAltAzAsync = False
End Property

Public Property Get CanSyncAltAz() As Boolean
    CanSyncAltAz = False
End Property

Public Property Get DriverVersion() As String
    DriverVersion = App.Major & "." & App.Minor
End Property

Public Property Get EquatorialSystem() As EquatorialCoordinateType
    EquatorialSystem = equOther
End Property

Public Property Get GuideRateDeclination() As Double
    err.Raise SCODE_NOT_IMPLEMENTED, ERR_SOURCE, _
              "Property Get GuideRateDeclination" & MSG_NOT_IMPLEMENTED
End Property

Public Property Let GuideRateDeclination(ByVal newval As Double)
    err.Raise SCODE_NOT_IMPLEMENTED, ERR_SOURCE, _
              "Property Let GuideRateDeclination" & MSG_NOT_IMPLEMENTED
End Property

Public Property Get GuideRateRightAscension() As Double
    err.Raise SCODE_NOT_IMPLEMENTED, ERR_SOURCE, _
              "Property Get GuideRateRightAscension" & MSG_NOT_IMPLEMENTED
End Property


Public Property Let GuideRateRightAscension(ByVal newval As Double)
    err.Raise SCODE_NOT_IMPLEMENTED, ERR_SOURCE, _
              "Property Let GuideRateRightAscension" & MSG_NOT_IMPLEMENTED
End Property


Public Property Get InterfaceVersion() As Integer
    InterfaceVersion = 2
End Property


Public Property Let SideOfPier(ByVal newval As PierSide)
    err.Raise SCODE_NOT_IMPLEMENTED, ERR_SOURCE, _
              "Property Let SideOfPier" & MSG_NOT_IMPLEMENTED
End Property
Public Property Get SideOfPier() As PierSide
    SideOfPier = pierUnknown
    err.Raise SCODE_NOT_IMPLEMENTED, ERR_SOURCE, _
              "Property Get SideOfPier" & MSG_NOT_IMPLEMENTED
End Property


Public Property Get TrackingRate() As DriveRates
    TrackingRate = driveSidereal
    err.Raise SCODE_NOT_IMPLEMENTED, ERR_SOURCE, _
              "Property Get TrackingRate" & MSG_NOT_IMPLEMENTED
End Property

Public Property Get TrackingRates() As Object
    Set TrackingRates = m_DriveRates
End Property

Public Function AxisRates(axis As AxisID) As Object
    err.Raise SCODE_NOT_IMPLEMENTED, ERR_SOURCE, _
              "Method AxisRates()" & MSG_NOT_IMPLEMENTED
End Function

Public Function CanMoveAxis(axis As AxisID) As Boolean
    CanMoveAxis = True
End Function

Public Function DestinationSideOfPier(ByVal destRa As Double, destDec As Double) As Long
    err.Raise SCODE_NOT_IMPLEMENTED, ERR_SOURCE, _
              "Method DestinationSideOfPier()" & MSG_NOT_IMPLEMENTED
End Function

Public Sub MoveAxis(axis As AxisID, rate As Double)

    If Not gSlewStatus Then
        If axis = AxisPrimary Then
            Call EQMoveAxis(0, rate)
        End If
    
        If axis = axisSecondary Then
            Call EQMoveAxis(1, rate)
        End If
    End If
        
End Sub
' special sub of PEc control - normal moveaxis results in background polling of motor positions
Public Sub PecMoveAxis(axis As AxisID, rate As Double)

    If Not gSlewStatus Then
        If axis = AxisPrimary Then
            Call EQPecMoveAxis(0, rate)
        End If
    
        If axis = axisSecondary Then
            Call EQPecMoveAxis(1, rate)
        End If
    End If
        
End Sub
Public Sub SlewToAltAz(ByVal Azimuth As Double, _
                        ByVal altitude As Double)
    err.Raise SCODE_NOT_IMPLEMENTED, ERR_SOURCE, _
              "Method SlewToAltAz()" & MSG_NOT_IMPLEMENTED
End Sub


Public Sub SlewToAltAzAsync(ByVal Azimuth As Double, _
                            ByVal altitude As Double)
    err.Raise SCODE_NOT_IMPLEMENTED, ERR_SOURCE, _
              "Method SlewToAltAzAsync()" & MSG_NOT_IMPLEMENTED
End Sub
Public Sub SyncToAltAz(ByVal Azimuth As Double, _
                        ByVal altitude As Double)
    err.Raise SCODE_NOT_IMPLEMENTED, ERR_SOURCE, _
              "Method SyncToAltAz()" & MSG_NOT_IMPLEMENTED
End Sub


'-------------------------- V1 Properties Starts here -----------------

Public Property Get DoesRefraction() As Boolean
    DoesRefraction = False
    err.Raise SCODE_NOT_IMPLEMENTED, ERR_SOURCE, _
              "Property Get DoesRefraction" & MSG_NOT_IMPLEMENTED
End Property

Public Property Get altitude() As Double

    altitude = gAlt
    
End Property

Public Property Get ApertureDiameter() As Double

    '** insert your implementation here and remove the following line
    err.Raise SCODE_NOT_IMPLEMENTED, ERR_SOURCE, _
                "Property ApertureDiameter" & MSG_NOT_IMPLEMENTED

End Property

Public Property Get ApertureArea() As Double

    '** insert your implementation here and remove the following line
    err.Raise SCODE_NOT_IMPLEMENTED, ERR_SOURCE, _
                "Property ApertureDiameter" & MSG_NOT_IMPLEMENTED

End Property

Public Property Get Azimuth() As Double

    Azimuth = gAz

End Property

Public Property Get CanFindHome() As Boolean

    CanFindHome = False

End Property

Public Property Get CanPark() As Boolean

    CanPark = True

End Property

Public Property Get CanSetPark() As Boolean

    CanSetPark = True

End Property

Public Property Get CanSetTracking() As Boolean

    CanSetTracking = True

End Property

Public Property Get CanSlew() As Boolean

    CanSlew = True

End Property

Public Property Get CanSlewAsync() As Boolean

    CanSlewAsync = True

End Property

Public Property Get CanSync() As Boolean

    CanSync = True

End Property

Public Property Get CanUnpark() As Boolean

    CanUnpark = True

End Property
Public Property Get CanPulseGuide() As Boolean

    CanPulseGuide = True

End Property

Public Property Get Connected() As Boolean

   
  If EQ_GetMountStatus() <> 1 Then
      Connected = False
  Else
      Connected = True
  End If
    
    
End Property

Public Property Let Connected(ByVal newval As Boolean)

    
Dim icast As Long

    If newval Then
    
    
'        Call ReadSiteValues
'        Call ReadSyncMap
'        Call ReadAlignMap
    
        If EQ_GetMountStatus() = 0 Then
        
            gRA_LastRate = 0
            gCurrent_time = 0
            gLast_time = 0
            gEmulRA_Init = 0
            
            gAlignmentStars_count = 0
        
            gEQRAPulseDuration = 0
            gEQDECPulseDuration = 0
            gEQPulsetimerflag = True
            gThreeStarEnable = False
            gSelectStar = 0
            gRA_GOTO = 0
            gDEC_GOTO = 0
            
            gRAMoveAxis_Rate = 0
            gDECMoveAxis_Rate = 0
            gSidFlag = 1
            gpl_interval = 50
        
            HC.Show
            
            
            gInitResult = EQ_Init(gPort, gBaud, gTimeout, gRetry)
            
            ' Make sure we have the right board
            
             eqres = CheckMount(gInitResult)
        
            If eqres = EQ_OK And EQ_GetMountStatus() = 1 Then
            
                eqres = EQ_GetTotal360microstep(0)
                If eqres < &H1000000 Then
                    gTot_RA = eqres
                    gRAWormSteps = EQ_GP(0, 10006)
                    If gRAWormSteps <> 50133 Or gRAWormSteps <> 66844 Then
                        ' mount isn't returning known values - read from ini instead
                        Call readWormSteps
                    End If
                    gRAWormPeriod = Int((SPSD * gRAWormSteps / gTot_RA) + 0.5)
                End If
                
                eqres = EQ_GetTotal360microstep(1)
                If eqres < &H1000000 Then
                    gTot_DEC = eqres
                    gDECWormSteps = EQ_GP(1, 10006)
                    If gDECWormSteps <> 50133 Or gDECWormSteps <> 66844 Then
                        ' mount isn't returning known values - read from ini instead
                        Call readWormSteps
                    End If
                End If
                
                'Make sure motors are not running
                eqres = EQ_MotorStop(0)     ' Stop RA Motor
                eqres = EQ_MotorStop(1)     ' Stop DEC Motor
                
                HC.TrackingFrame.Caption = HC.oLangDll.GetLangString(121) & " " & HC.oLangDll.GetLangString(178)
                
                'Get state of at least one of the motors
                
                eqres = EQ_GetMotorStatus(0)
                
                ' If its an error then Initialize it
                
                If eqres = EQ_NOTINITIALIZED Then
                    icast = gDECEncoder_Home_pos ' Typecast
                    eqres = EQ_InitMotors(RAEncoder_Home_pos, icast)
                End If
                
                gMount_Ver = EQ_GetMountVersion()
                

                            
                'Make sure we get the latest data from the registry
               
               
                HC.Add_Message (HC.oLangDll.GetLangString(5132) & " " & gPort & ":" & Str(gBaud))
                HC.Add_Message (HC.oLangDll.GetLangString(5133) & " " & printhex(EQ_GetMountVersion()) & " DLL Version:" & printhex(EQ_DriverVersion()))
                HC.Add_Message CStr(gRAWormSteps) & " Steps per RA worm rotation"
                HC.EncoderTimer.Enabled = True
                HC.EncoderTimerFlag = True
                gEQPulsetimerflag = True
                HC.Pulseguide_Timer.Enabled = False     'Enabled only during pulseguide session
                
                Call readParkModes
                gEQparkstatus = readparkStatus()
    
                If gEQparkstatus = 1 Then
                    HC.Frame15.Caption = HC.oLangDll.GetLangString(146) & " " & HC.oLangDll.GetLangString(177)
                Else
                    HC.Frame15.Caption = HC.oLangDll.GetLangString(146) & " " & HC.oLangDll.GetLangString(179)
                End If
                Call SetParkCaption

    
                Call readportrate ' Read Autoguider port settings from registry and send to mount
                Call readRASyncCheckVal ' RA Sync Auto
                Call readDriftVal ' Read the Drift offset value
                Call readPulseguidepwidth ' Read Pulseguide interval
                Call PEC_Initialise   ' only initialise PEc when we've defaults for worm

            Else
                HC.EncoderTimer.Enabled = False
                HC.EncoderTimerFlag = False
                eqres = EQ_End()
                HC.Add_Message (HC.oLangDll.GetLangString(5135) & " " & gPort & ":" & Str(gBaud))
            
            End If
        End If
    Else
        If ClientCount <= 2 Then
    
           If EQ_GetMountStatus() = 1 Then     ' We update only if the mount is online
               writeParkStatus gEQparkstatus
           End If
       
           HC.EncoderTimer.Enabled = False
           HC.EncoderTimerFlag = False
           
           'Save alignment and Sync data if scope is parked
           'Otherwise an re-alignment / re-Sync process has to be made on restart
           
    '       If gEQparkstatus = 1 Then
    '           Call WriteSyncMap
    '           Call WriteAlignMap
    '       End If
           
       
           eqres = EQ_End()
           
           ' Added to save settings
           
            writeDriftVal
            writeRASyncCheckVal
            writePulseguidepwidth
            
        End If
        

        
    End If

End Property

Public Property Get Declination() As Double

    Declination = gDec

End Property

Public Property Get DeclinationRate() As Double

    DeclinationRate = gDeclinationRate

End Property

Public Property Let DeclinationRate(ByVal newval As Double)

    If (gDeclinationRate * newval) <= 0 Then
        Call StartDEC_by_Rate(newval)
    Else
        Call ChangeDEC_by_Rate(newval)
    End If
    
    gDeclinationRate = newval
    gTrackingStatus = 4

End Property

Public Property Get Description() As String

    Description = "EQMOD ASCOM Driver"
    
End Property

Public Property Get DriverInfo() As String
    '
    ' Use the Project/Properties sheet, Make tab, to set these
    ' items. That way they will show in the Version tab of the
    ' Explorer property sheet, and the exact same data will
    ' show in Telescope.DriverInfo.
    '
    DriverInfo = App.FileDescription & " " & _
                App.Major & "." & App.Minor & "." & App.Revision
    If App.CompanyName <> "" Then _
        DriverInfo = DriverInfo & vbCrLf & App.CompanyName
    If App.LegalCopyright <> "" Then _
        DriverInfo = DriverInfo & vbCrLf & App.LegalCopyright
    If App.Comments <> "" Then _
        DriverInfo = DriverInfo & vbCrLf & App.Comments
        
End Property

Public Property Get FocalLength() As Double

    '** insert your implementation here and remove the following line
    err.Raise SCODE_NOT_IMPLEMENTED, ERR_SOURCE, _
                "Property FocalLength" & MSG_NOT_IMPLEMENTED

End Property

Public Property Get Name() As String

    Name = ASCOM_DESC                        ' 1-word name
    
End Property

Public Property Get RightAscension() As Double


    RightAscension = GetEmulRA_EQ()

End Property

Public Property Get RightAscensionRate() As Double

    RightAscensionRate = gRightAscensionRate
    
    
End Property

Public Property Let RightAscensionRate(ByVal newval As Double)

    'newval is in arcseconds , convert to degrees

 
    newval = SID_RATE + newval      ' Treat newval as an offset

    If (gRightAscensionRate * newval) <= 0 Then
        Call StartRA_by_Rate(newval)
    Else
        Call ChangeRA_by_Rate(newval)
    End If
    
    gRightAscensionRate = newval
    gTrackingStatus = 4
    
End Property

Public Property Get SiderealTime() As Double

    SiderealTime = EQnow_lst(gLongitude * DEG_RAD)

End Property

Public Property Get SiteElevation() As Double

   SiteElevation = gElevation

End Property

Public Property Let SiteElevation(ByVal newval As Double)

    '** insert your implementation here and remove the following line
    err.Raise SCODE_NOT_IMPLEMENTED, ERR_SOURCE, _
                "Property SiteElevation" & MSG_NOT_IMPLEMENTED

End Property

Public Property Get SiteLatitude() As Double

    SiteLatitude = gLatitude

End Property

Public Property Let SiteLatitude(ByVal newval As Double)

    '** insert your implementation here and remove the following line
    err.Raise SCODE_NOT_IMPLEMENTED, ERR_SOURCE, _
                "Property SiteLatitude" & MSG_NOT_IMPLEMENTED

End Property

Public Property Get SiteLongitude() As Double

    SiteLongitude = gLongitude

End Property

Public Property Let SiteLongitude(ByVal newval As Double)

    '** insert your implementation here and remove the following line
    err.Raise SCODE_NOT_IMPLEMENTED, ERR_SOURCE, _
                "Property SiteLongitude" & MSG_NOT_IMPLEMENTED

End Property

Public Property Get Slewing() As Boolean

    Slewing = gSlewStatus

End Property

Public Property Get SlewSettleTime() As Integer

    SlewSettleTime = m_iSettleTime
    
End Property

Public Property Let SlewSettleTime(ByVal newval As Integer)

    If (newval < 0) Or (newval > 100) Then _
        err.Raise SCODE_PROP_RANGE_ERROR, ERR_SOURCE, MSG_PROP_RANGE_ERROR
        
    m_iSettleTime = newval
    
End Property

Public Property Get TargetDeclination() As Double

    If gTargetDec = EQ_INVALIDCOORDINATE Then _
        err.Raise SCODE_PROP_NOT_SET, ERR_SOURCE, _
            "Property Declination " & MSG_PROP_NOT_SET

    TargetDeclination = gTargetDec

End Property

Public Property Let TargetDeclination(ByVal newval As Double)

    gTargetDec = newval
    
End Property

Public Property Get TargetRightAscension() As Double

    If gTargetRA = EQ_INVALIDCOORDINATE Then _
        err.Raise SCODE_PROP_NOT_SET, ERR_SOURCE, _
            "Property Ascension " & MSG_PROP_NOT_SET


    TargetRightAscension = gTargetRA

End Property

Public Property Let TargetRightAscension(ByVal newval As Double)

    gTargetRA = newval
    

End Property

Public Property Get Tracking() As Boolean

    If gTrackingStatus <> 0 Then
    
        Tracking = True
    Else
        Tracking = False
        
    End If
    
End Property

Public Property Let Tracking(ByVal newval As Boolean)


   If gEQparkstatus = 0 Then
    If newval Then
    
        eqres = EQ_StartRATrack(0, gHemisphere, gHemisphere)
        eqres = EQ_MotorStop(1)
        
        gRA_LastRate = 0
        gDeclinationRate = 0
        gRightAscensionRate = SID_RATE
        
        gTrackingStatus = 1                 'Sidreal rate tracking'
        HC.TrackingFrame.Caption = HC.oLangDll.GetLangString(121) & " " & HC.oLangDll.GetLangString(122)
        gEmulOneShot = True                 ' Get One shot cap
    
    Else
    
        eqres = EQ_MotorStop(0)
        eqres = EQ_MotorStop(1)
        gTrackingStatus = 0
        gDeclinationRate = 0
        gRightAscensionRate = 0
        
        HC.TrackingFrame.Caption = HC.oLangDll.GetLangString(121) & " " & HC.oLangDll.GetLangString(178)
    
    End If
   Else
   
    HC.Add_Message (HC.oLangDll.GetLangString(5013))
   
   End If

End Property

Public Property Get UTCDate() As Date

    UTCDate = CDate(CDbl(Now()) + (CDbl(utc_offs()) / 86400#))
        
End Property

Public Property Let UTCDate(ByVal newval As Date)

     'Impossible to set own PC time

     err.Raise SCODE_NOT_IMPLEMENTED, ERR_SOURCE, _
                "Property UTCDate" & MSG_NOT_IMPLEMENTED

End Property

Public Property Get RAMotor() As Long

    'RAMotor = EQ_GetMotorValues(0)
     RAMotor = GetEmulRA()
        
End Property

Public Property Get DECMotor() As Long

    'DECMotor = EQ_GetMotorValues(1)
    DECMotor = gEmulDEC
        
End Property

Public Property Get SyncRAMotor() As Long

     gEmulRA = EQ_GetMotorValues(0)
     SyncRAMotor = gEmulRA
    
     gLast_time = EQnow_lst_norange()
     gCurrent_time = gLast_time
     gEmulRA_Init = gEmulRA
        
End Property

Public Property Get SyncDECMotor() As Long

     gEmulDEC = EQ_GetMotorValues(1)
     SyncDECMotor = gEmulDEC
        
End Property
Public Property Get RAWormPeriod() As Long
     RAWormPeriod = gRAWormPeriod
End Property
Public Property Get RAWormPeriodFloat() As Double
    RAWormPeriodFloat = SPSD * gRAWormSteps / gTot_RA
End Property

' ------------------------- Methods Portion of the Code -------------


Public Sub AbortSlew()

    'Stop all motors

    eqres = EQ_MotorStop(0)
    eqres = EQ_MotorStop(1)
    
    'Disable HC Slew timers
    
    gSlewStatus = False
    gRAStatus_slew = False
    HC.GotoTimer.Enabled = False

End Sub

Public Sub CommandBlind(ByVal Command As String)

    '** insert your implementation here and remove the following line
    err.Raise SCODE_NOT_IMPLEMENTED, ERR_SOURCE, _
                "Method xxx()" & MSG_NOT_IMPLEMENTED

End Sub

Public Function CommandBool(ByVal Command As String) As Boolean

    '** insert your implementation here and remove the following line
    err.Raise SCODE_NOT_IMPLEMENTED, ERR_SOURCE, _
                "Method CommandBlind()" & MSG_NOT_IMPLEMENTED

End Function

Public Function CommandString(ByVal Command As String) As String

    '** insert your implementation here and remove the following line
    err.Raise SCODE_NOT_IMPLEMENTED, ERR_SOURCE, _
                "Method CommandString()" & MSG_NOT_IMPLEMENTED

End Function

Public Sub FindHome()

    '** insert your implementation here and remove the following line
    err.Raise SCODE_NOT_IMPLEMENTED, ERR_SOURCE, _
                "Method FindHome()" & MSG_NOT_IMPLEMENTED

End Sub

Public Sub Park()

    If gEQparkstatus = 0 Then
        ParktoUserDefine (True)
        gEQparkstatus = 1
        HC.TrackingFrame.Caption = HC.oLangDll.GetLangString(121) & " " & HC.oLangDll.GetLangString(178)
        HC.Frame15.Caption = HC.oLangDll.GetLangString(146) & " " & HC.oLangDll.GetLangString(50)
        HC.CommandPark.Caption = HC.oLangDll.GetLangString(151)
        HC.Add_Message ("Scope parked. You may turn it off after slewing")
    End If

End Sub

Public Property Get IsPulseGuiding() As Boolean

    If (gEQRAPulseDuration + gEQDECPulseDuration) <> 0 Then
        IsPulseGuiding = True
    Else
        IsPulseGuiding = False
    End If
    
End Property

Public Sub PulseGuide(ByVal direction As GuideDirections, _
                                            ByVal Duration As Long)
    
    'Pulse guide implentation for EQMOD
    'This uses the duration parameter and an asynchronous timer
    'that will decrement the duration count for every time tick
    'It then disables the guiderate upon expiration of the counter
    
    HC.Pulseguide_Timer.Enabled = False
    
    If (gTrackingStatus = 4) Then
    If Duration = 0 Then
      Select Case (direction)
        Case guideNorth 'DEC+
            If HC.decpulse_enchk.value = 1 Then
                gEQDECPulseDuration = 0
                Call ChangeDEC_by_Rate(gDeclinationRate)
                If HC.Frame16.Visible = True Then Call Plot_points(1, 0, 0)
             End If
 
        Case guideSouth 'DEC-
            If HC.decpulse_enchk.value = 1 Then
                gEQDECPulseDuration = 0
                Call ChangeDEC_by_Rate(gDeclinationRate)
                If HC.Frame16.Visible = True Then Call Plot_points(1, 1, 0)
            End If
        Case guideEast  'RA+
            If HC.rapulse_enchk.value = 1 Then
                If gRA_LastRate = 0 Then
                    eqres = EQ_SendGuideRate(0, gTrackingStatus - 1, 0, 0, gHemisphere, gHemisphere)
                Else
                    ChangeRA_by_Rate (gRightAscensionRate)
                End If
                gEQRAPulseDuration = 0
                If HC.Frame16.Visible = True Then Call Plot_points(0, 0, 0)
            End If
        Case guideWest  'RA-
            If HC.rapulse_enchk.value = 1 Then
                If gRA_LastRate = 0 Then
                    eqres = EQ_SendGuideRate(0, gTrackingStatus - 1, 0, 0, gHemisphere, gHemisphere)
                Else
                    ChangeRA_by_Rate (gRightAscensionRate)
                End If
                If HC.Frame16.Visible = True Then Call Plot_points(0, 1, 0)
                gEQRAPulseDuration = 0
           End If
        Case Else
            err.Raise SCODE_PROP_RANGE_ERROR, ERR_SOURCE, _
                "Pulse Guide: GuideDirections" & MSG_PROP_RANGE_ERROR
       End Select
    
    Else
    
      Select Case (direction)
        Case guideNorth 'DEC+
            If HC.decpulse_enchk.value = 1 Then
            
                Call ChangeDEC_by_Rate(gDeclinationRate + (gDeclinationRate * HC.VScroll4.value * 0.1))
                
                If HC.decfixed_enchk.value = 0 Then
                    gEQDECPulseDuration = Duration * (HC.HScrollDECWidth.value / 100)
                Else
                    gEQDECPulseDuration = HC.VScroll6.value * 100
                End If
                
                If HC.Frame16.Visible = True Then Call Plot_points(1, 0, gEQDECPulseDuration)
            End If
            
        Case guideSouth 'DEC-
            If HC.decpulse_enchk.value = 1 Then
            
                Call ChangeDEC_by_Rate(gDeclinationRate - (gDeclinationRate * HC.VScroll4.value * 0.1))
                
                eqres = EQ_SendGuideRate(1, gTrackingStatus - 1, val(HC.VScroll4.value), 0, 0, 0)
                If HC.decfixed_enchk.value = 0 Then
                    gEQDECPulseDuration = Duration * (HC.HScrollDECWidth.value / 100)
                Else
                    gEQDECPulseDuration = HC.VScroll6.value * 100
                End If
                If HC.Frame16.Visible = True Then Call Plot_points(1, 1, gEQDECPulseDuration)
            End If
        Case guideEast  'RA+
            If HC.rapulse_enchk.value = 1 Then
            
                If gRA_LastRate = 0 Then
                    eqres = EQ_SendGuideRate(0, gTrackingStatus - 1, val(HC.VScroll3.value), 1, gHemisphere, gHemisphere)
                Else
                    Call ChangeRA_by_Rate(gRightAscensionRate - (gRightAscensionRate * HC.VScroll3.value * 0.1))
                End If
              
                If HC.rafixed_enchk.value = 0 Then
                    gEQRAPulseDuration = Duration * (HC.HScrollRAWidth.value / 100)
                Else
                    gEQRAPulseDuration = HC.VScroll5.value * 100
                End If
                
                If HC.Frame16.Visible = True Then Call Plot_points(0, 0, gEQRAPulseDuration)
            End If
        Case guideWest  'RA-
            If HC.rapulse_enchk.value = 1 Then
                
                 If gRA_LastRate = 0 Then
                    eqres = EQ_SendGuideRate(0, gTrackingStatus - 1, val(HC.VScroll3.value), 0, gHemisphere, gHemisphere)
                Else
                    Call ChangeRA_by_Rate(gRightAscensionRate + (gRightAscensionRate * HC.VScroll3.value * 0.1))
                End If

                              
                If HC.rafixed_enchk.value = 0 Then
                    gEQRAPulseDuration = Duration * (HC.HScrollRAWidth.value / 100)
                Else
                    gEQRAPulseDuration = HC.VScroll5.value * 100
                End If
                If HC.Frame16.Visible = True Then Call Plot_points(0, 1, gEQRAPulseDuration)
            End If
        Case Else
            err.Raise SCODE_PROP_RANGE_ERROR, ERR_SOURCE, _
                "Pulse Guide: GuideDirections" & MSG_PROP_RANGE_ERROR
      End Select
     End If
    Else
     
    ' Process if Equatorial Tracking
     
     If Duration = 0 Then

      Select Case (direction)
        Case guideNorth 'DEC+
            If HC.decpulse_enchk.value = 1 Then
                eqres = EQ_MotorStop(1)
                If eqres = 1 Then GoTo PError
                Do
                  eqres = EQ_GetMotorStatus(1)
                  If eqres = 1 Then GoTo PError
                Loop While (eqres And &H10) <> 0
                gEQDECPulseDuration = 0
                If HC.Frame16.Visible = True Then Call Plot_points(1, 0, 0)
            End If
 
        Case guideSouth 'DEC-
            If HC.decpulse_enchk.value = 1 Then
                eqres = EQ_MotorStop(1)
                If eqres = 1 Then GoTo PError
                Do
                  eqres = EQ_GetMotorStatus(1)
                  If eqres = 1 Then GoTo PError
                Loop While (eqres And &H10) <> 0
                gEQDECPulseDuration = 0
                If HC.Frame16.Visible = True Then Call Plot_points(1, 1, 0)
            End If
        Case guideEast  'RA+
            If HC.rapulse_enchk.value = 1 Then
                eqres = EQ_SendGuideRate(0, gTrackingStatus - 1, 0, 0, gHemisphere, gHemisphere)
                gEQRAPulseDuration = 0
                If HC.Frame16.Visible = True Then Call Plot_points(0, 0, 0)
            End If
        Case guideWest  'RA-
            If HC.rapulse_enchk.value = 1 Then
                eqres = EQ_SendGuideRate(0, gTrackingStatus - 1, 0, 0, gHemisphere, gHemisphere)
                gEQRAPulseDuration = 0
                If HC.Frame16.Visible = True Then Call Plot_points(0, 1, 0)
            End If
        Case Else
            err.Raise SCODE_PROP_RANGE_ERROR, ERR_SOURCE, _
                "Pulse Guide: GuideDirections" & MSG_PROP_RANGE_ERROR
       End Select
    
    Else
    
      Select Case (direction)
        Case guideNorth 'DEC+
            If HC.decpulse_enchk.value = 1 Then
            
                eqres = EQ_MotorStop(1)
                If eqres = 1 Then GoTo PError
                Do
                  eqres = EQ_GetMotorStatus(1)
                  If eqres = 1 Then GoTo PError
                Loop While (eqres And &H10) <> 0
            
                eqres = EQ_SendGuideRate(1, gTrackingStatus - 1, val(HC.VScroll4.value), 1, 0, 0)
                If HC.decfixed_enchk.value = 0 Then
                    gEQDECPulseDuration = Duration * (HC.HScrollDECWidth.value / 100)
                Else
                    gEQDECPulseDuration = HC.VScroll6.value * 100
                End If
                If HC.Frame16.Visible = True Then Call Plot_points(1, 0, gEQDECPulseDuration)
            End If
            
        Case guideSouth 'DEC-
            If HC.decpulse_enchk.value = 1 Then
            
                eqres = EQ_MotorStop(1)
                If eqres = 1 Then GoTo PError
                Do
                  eqres = EQ_GetMotorStatus(1)
                  If eqres = 1 Then GoTo PError
                Loop While (eqres And &H10) <> 0
                
                eqres = EQ_SendGuideRate(1, gTrackingStatus - 1, val(HC.VScroll4.value), 0, 0, 0)
                If HC.decfixed_enchk.value = 0 Then
                    gEQDECPulseDuration = Duration * (HC.HScrollDECWidth.value / 100)
                Else
                    gEQDECPulseDuration = HC.VScroll6.value * 100
                End If
                If HC.Frame16.Visible = True Then Call Plot_points(1, 1, gEQDECPulseDuration)
            End If
        Case guideEast  'RA+
            If HC.rapulse_enchk.value = 1 Then
                eqres = EQ_SendGuideRate(0, gTrackingStatus - 1, val(HC.VScroll3.value), 1, gHemisphere, gHemisphere)
                If HC.rafixed_enchk.value = 0 Then
                    gEQRAPulseDuration = Duration * (HC.HScrollRAWidth.value / 100)
                Else
                    gEQRAPulseDuration = HC.VScroll5.value * 100
                End If
                If HC.Frame16.Visible = True Then Call Plot_points(0, 0, gEQRAPulseDuration)
            End If
        Case guideWest  'RA-
            If HC.rapulse_enchk.value = 1 Then
                eqres = EQ_SendGuideRate(0, gTrackingStatus - 1, val(HC.VScroll3.value), 0, gHemisphere, gHemisphere)
                If HC.rafixed_enchk.value = 0 Then
                    gEQRAPulseDuration = Duration * (HC.HScrollRAWidth.value / 100)
                Else
                    gEQRAPulseDuration = HC.VScroll5.value * 100
                End If
                If HC.Frame16.Visible = True Then Call Plot_points(0, 1, gEQRAPulseDuration)
            End If
        Case Else
            err.Raise SCODE_PROP_RANGE_ERROR, ERR_SOURCE, _
                "Pulse Guide: GuideDirections" & MSG_PROP_RANGE_ERROR
      End Select
     End If
    End If
    HC.Pulseguide_Timer.Enabled = True
    
PError:

End Sub

Public Sub SetPark()

    HC.Add_Message (HC.oLangDll.GetLangString(5004))
    DefinePark (True)

End Sub

Public Sub SetupDialog()

Unload Setupfrm
Setupfrm.Show 1

End Sub

Public Sub SlewToCoordinates(ByVal RightAscension As Double, _
                                    ByVal Declination As Double)
    
 If gEQparkstatus = 0 Then
        If Align.Visible Then
            Call Align.FillAlignmentStar(RightAscension, Declination)
        End If
        gTargetRA = RightAscension
        gTargetDec = Declination
        HC.Add_Message ("SyncCSlew: " & HC.oLangDll.GetLangString(105) & "[ " & FmtSexa(gTargetRA, False) & " ] " & HC.oLangDll.GetLangString(106) & "[ " & FmtSexa(gTargetDec, True) & " ]")
        gSlewCount = NUM_SLEW_RETRIES               'Set initial iterative slew count
        Call radecAsyncSlew(False)
Else
        HC.Add_Message (HC.oLangDll.GetLangString(5000))
End If
End Sub

Public Sub SlewToCoordinatesAsync(ByVal RightAscension As Double, _
                                    ByVal Declination As Double)
    If gEQparkstatus = 0 Then
    
        If Align.Visible Then
            Call Align.FillAlignmentStar(RightAscension, Declination)
        End If
        gTargetRA = RightAscension
        gTargetDec = Declination
        HC.Add_Message ("CoordSlew: " & HC.oLangDll.GetLangString(105) & "[ " & FmtSexa(gTargetRA, False) & " ] " & HC.oLangDll.GetLangString(106) & "[ " & FmtSexa(gTargetDec, True) & " ]")
        gSlewCount = NUM_SLEW_RETRIES               'Set initial iterative slew count
        Call radecAsyncSlew(False)
    Else
        HC.Add_Message (HC.oLangDll.GetLangString(5000))
    End If
End Sub

Public Sub SlewToTarget()

    If gEQparkstatus = 0 Then
        If Align.Visible Then
            Call Align.FillAlignmentStar(gTargetRA, gTargetDec)
        End If
        HC.Add_Message ("SyncSlew: " & HC.oLangDll.GetLangString(105) & "[ " & FmtSexa(gTargetRA, False) & "] " & HC.oLangDll.GetLangString(106) & "[ " & FmtSexa(gTargetDec, True) & " ]")
        gSlewCount = NUM_SLEW_RETRIES               'Set initial iterative slew count
        Call radecAsyncSlew(False)
    Else
        HC.Add_Message (HC.oLangDll.GetLangString(5000))
    End If
    
End Sub

Public Sub SlewToTargetAsync()

    If gEQparkstatus = 0 Then
        If Align.Visible Then
            Call Align.FillAlignmentStar(gTargetRA, gTargetDec)
        End If
        HC.Add_Message ("AsyncSlew: " & HC.oLangDll.GetLangString(105) & "[ " & FmtSexa(gTargetRA, False) & "] " & HC.oLangDll.GetLangString(106) & "[ " & FmtSexa(gTargetDec, True) & " ]")
        gSlewCount = NUM_SLEW_RETRIES               'Set initial iterative slew count
        Call radecAsyncSlew(False)
    Else
        HC.Add_Message (HC.oLangDll.GetLangString(5000))
    End If
    
End Sub

Public Sub SyncToCoordinates(ByVal RightAscension As Double, _
                                    ByVal Declination As Double)
                                    

    HC.Add_Message ("SynCoor: " & HC.oLangDll.GetLangString(105) & "[ " & FmtSexa(RightAscension, False) & "] " & HC.oLangDll.GetLangString(106) & "[ " & FmtSexa(Declination, True) & " ]")
    SyncToRADEC RightAscension, Declination, gLongitude, gHemisphere

End Sub

Public Sub SyncToTarget()

    HC.Add_Message ("SyncTaget: " & HC.oLangDll.GetLangString(105) & "[ " & FmtSexa(gTargetRA, False) & "] " & HC.oLangDll.GetLangString(106) & "[ " & FmtSexa(gTargetDec, True) & " ]")
    SyncToRADEC gTargetRA, gTargetDec, gLongitude, gHemisphere


End Sub

Public Sub UnPark()


    If EQ_GetMountStatus() = 1 Then     ' Make sure that we unpark only if the mount is online
        If gEQparkstatus = 1 Then
            HC.TrackingFrame.Caption = HC.oLangDll.GetLangString(121) & " " & HC.oLangDll.GetLangString(178)
            Unparkscope
            gEQparkstatus = 0
            HC.Frame15.Caption = HC.oLangDll.GetLangString(146) & " " & HC.oLangDll.GetLangString(179)
            HC.CommandPark.Caption = HC.oLangDll.GetLangString(1500)
        Else
            HC.Add_Message (HC.oLangDll.GetLangString(5037))
        End If
    End If
    
End Sub




Public Sub ReadComPortSettings()

   
     Dim tmptxt As String
   
     tmptxt = HC.oPersist.ReadIniValue("Port")
     If tmptxt <> "" Then
        gPort = tmptxt
     Else
        gPort = "COM1"
     End If
     
     tmptxt = HC.oPersist.ReadIniValue("Baud")
     If tmptxt <> "" Then
        gBaud = val(tmptxt)
     Else
        gBaud = 9600
     End If
     
     tmptxt = HC.oPersist.ReadIniValue("Timeout")
     If tmptxt <> "" Then
        gTimeout = val(tmptxt)
     Else
        gTimeout = 1000
     End If
     

     tmptxt = HC.oPersist.ReadIniValue("Retry")
     If tmptxt <> "" Then
        gRetry = val(tmptxt)
     Else
        gRetry = 1
     End If
     
End Sub

Public Sub ReadSyncMap()

     Dim tmptxt As String

     tmptxt = HC.oPersist.ReadIniValue("RSYNC01")
     If tmptxt <> "" Then
        gRASync01 = val(tmptxt)
     Else
        gRASync01 = 0
     End If
     
     tmptxt = HC.oPersist.ReadIniValue("DSYNC01")
     If tmptxt <> "" Then
        gDECSync01 = val(tmptxt)
     Else
        gDECSync01 = 0
     End If

    HC.DxSalbl.Caption = Format$(Str(gRASync01), "000000000")
    HC.DxSblbl.Caption = Format$(Str(gDECSync01), "000000000")

End Sub
Public Sub ReadAlignMap()

     Dim tmptxt As String

     tmptxt = HC.oPersist.ReadIniValue("RALIGN01")
     If tmptxt <> "" Then
        gRA1Star = val(tmptxt)
     Else
        gRA1Star = 0
     End If
     
     tmptxt = HC.oPersist.ReadIniValue("DALIGN01")
     If tmptxt <> "" Then
        gDEC1Star = val(tmptxt)
     Else
        gDEC1Star = 0
     End If
     
     HC.Add_Message_Align ("---------------------------")
     HC.Add_Message_Align (HC.oLangDll.GetLangString(6000))
     HC.Add_Message_Align (HC.oLangDll.GetLangString(105) & ":" & Format$(Str(gRA1Star), "000000000") & " " & HC.oLangDll.GetLangString(106) & ":" & Format$(Str(gDEC1Star), "000000000"))
     HC.Add_Message_Align (HC.oLangDll.GetLangString(6002))

  
End Sub



