VERSION 5.00
Begin VB.Form StarEditform 
   BackColor       =   &H00000000&
   BorderStyle     =   4  'Fixed ToolWindow
   Caption         =   "Alignment Star List Editor"
   ClientHeight    =   3765
   ClientLeft      =   45
   ClientTop       =   390
   ClientWidth     =   8475
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3765
   ScaleWidth      =   8475
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton LoadCommand 
      Caption         =   "Load"
      BeginProperty Font 
         Name            =   "Arial Narrow"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   2760
      TabIndex        =   7
      Top             =   3255
      Width           =   1215
   End
   Begin VB.CommandButton Goto_Command 
      Caption         =   "Goto Star"
      BeginProperty Font 
         Name            =   "Arial Narrow"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   1440
      TabIndex        =   6
      Top             =   3255
      Width           =   1215
   End
   Begin VB.CommandButton Delete_Star_Command 
      Caption         =   "Delete Star"
      BeginProperty Font 
         Name            =   "Arial Narrow"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   120
      TabIndex        =   5
      Top             =   3255
      Width           =   1215
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Close"
      BeginProperty Font 
         Name            =   "Arial Narrow"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   7080
      TabIndex        =   4
      Top             =   3240
      Width           =   1215
   End
   Begin VB.CommandButton Save_Command 
      Caption         =   "Save"
      BeginProperty Font 
         Name            =   "Arial Narrow"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   5760
      TabIndex        =   3
      Top             =   3240
      Width           =   1215
   End
   Begin VB.ComboBox PresetCombo 
      BackColor       =   &H00000080&
      ForeColor       =   &H000080FF&
      Height          =   315
      Left            =   4080
      TabIndex        =   2
      Text            =   "Presets"
      Top             =   3285
      Width           =   1575
   End
   Begin VB.ListBox StarList 
      BackColor       =   &H00000080&
      ForeColor       =   &H000080FF&
      Height          =   2790
      Left            =   120
      TabIndex        =   0
      Top             =   360
      Width           =   8175
   End
   Begin VB.Label Label1 
      BackColor       =   &H00000000&
      Caption         =   "No. Time : RA , DEC, RA Offset Diff (microsteps), DEC Offset Diff (microsteps)"
      ForeColor       =   &H000080FF&
      Height          =   255
      Left            =   240
      TabIndex        =   1
      Top             =   120
      Width           =   5535
   End
End
Attribute VB_Name = "StarEditform"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private PresetIdx As Integer


Private Sub Command1_Click()
    Unload StarEditform
End Sub

Private Sub Delete_Star_Command_Click()
Dim Index, DeleteThisOne As Integer
    DeleteThisOne = StarList.ListIndex + 1 ' listindex is 0 based, starlist is 1 based
    If DeleteThisOne <> gAlignmentStars_count Then
        ' first or middle element, move elements one spot
        For Index = DeleteThisOne To gAlignmentStars_count - 1
            AlignmentStars(Index) = AlignmentStars(Index + 1)
        Next Index
    End If
    gAlignmentStars_count = gAlignmentStars_count - 1
    FillStarList
    
    ' Update Matrix data
    gThreeStarEnable = False
    
    'Make sure we activate the matrix only if there are three stars.
    
    If gAlignmentStars_count >= 3 Then
        Call SendtoMatrix(gAlignmentStars_count)
    Else
        HC.Add_Message_Align (HC.oLangDll.GetLangString(5032))
    End If
End Sub

Private Sub Form_Load()
    Call SetText
    ' poplate the star list
    
    If HC.HCOnTop.Value = 1 Then Call PutWindowOnTop(StarEditform)
    FillStarList
    ' Initialise the Preset Combo
    ReadPresets
End Sub

Private Sub FillStarList()
Dim Index As Integer
    StarList.Clear
    For Index = 1 To gAlignmentStars_count
        With AlignmentStars(Index)
            StarList.AddItem (CStr(Index) + ") " + CStr(.AlignTime) + " : RA[" + FmtSexa(.OrigTargetRA, False) + "] , DEC[" + FmtSexa(.OrigTargetDEC, False) + "]" + "  RA:" + Format$(Str(.TargetRA - .EncoderRA), "0000000") + "  DEC:" + Format$(Str(.TargetDEC - .EncoderDEC), "0000000"))
        End With
    Next Index
End Sub


Private Sub Form_Unload(Cancel As Integer)
    ' save current preset index to ini
    SavePresetIdx
End Sub

Private Sub Goto_Command_Click()
    With AlignmentStars(StarList.ListIndex + 1)
        If (.OrigTargetRA + .OrigTargetDEC) <> 0 Then
            Call m_telescope.SlewToCoordinates(.OrigTargetRA, .OrigTargetDEC)
        End If
    End With
End Sub

Private Sub LoadCommand_Click()
    Call LoadPreset(PresetIdx)
    FillStarList
End Sub

Private Sub PresetCombo_Click()
    PresetIdx = PresetCombo.ListIndex
    ' Force loss of focus
     SendKeys "{TAB}", True

End Sub

Private Sub Save_Command_Click()
    PresetCombo.List(PresetIdx) = PresetCombo.Text
    ' save the preset to file
    Call SaveAlignmentStars(PresetIdx, PresetCombo.List(PresetIdx))
    ' load it from file
    PresetCombo.ListIndex = PresetIdx
End Sub

Private Sub LoadPreset(preset As Integer)
Dim count As Integer
Dim tmptxt As String
Dim tmptxt2 As String
Dim VarStr As String
Dim Pos As Integer
Dim Index As Integer
Dim ValidCount As Integer
Dim MaxCount As Integer
Dim NewData As AlignmentData
Dim key As String
Dim AlignIni As String

    ' set up a file path for the align.ini file
    AlignIni = HC.oPersist.GetIniPath & "\ALIGN.ini"

    key = "[alignment_preset" & CStr(preset) & "]"

    tmptxt = HC.oPersist.ReadIniValueEx("STAR_COUNT", key, AlignIni)
    If tmptxt <> "" Then
        MaxCount = val(tmptxt)
        If MaxCount > MAX_STARS Then
            MaxCount = MAX_STARS
        End If
    Else
        MaxCount = 0
    End If

    If MaxCount <> 0 Then
        ValidCount = 0
        For Index = 1 To MaxCount
            VarStr = "Star" + CStr(Index)
            tmptxt = HC.oPersist.ReadIniValueEx(VarStr, key, AlignIni)
            If tmptxt <> "" Then
                Pos = InStr(tmptxt, ";")
                If Pos = 0 Then GoTo DecodeError
                tmptxt2 = Left$(tmptxt, Pos - 1)
                tmptxt = Right$(tmptxt, Len(tmptxt) - Pos)
                NewData.AlignTime = tmptxt2
                    
                Pos = InStr(tmptxt, ";")
                If Pos = 0 Then GoTo DecodeError
                tmptxt2 = Left$(tmptxt, Pos - 1)
                tmptxt = Right$(tmptxt, Len(tmptxt) - Pos)
                NewData.OrigTargetRA = val(tmptxt2)
                
                Pos = InStr(tmptxt, ";")
                If Pos = 0 Then GoTo DecodeError
                tmptxt2 = Left$(tmptxt, Pos - 1)
                tmptxt = Right$(tmptxt, Len(tmptxt) - Pos)
                NewData.OrigTargetDEC = val(tmptxt2)
                
                Pos = InStr(tmptxt, ";")
                If Pos = 0 Then GoTo DecodeError
                tmptxt2 = Left$(tmptxt, Pos - 1)
                tmptxt = Right$(tmptxt, Len(tmptxt) - Pos)
                NewData.TargetRA = val(tmptxt2)
                
                Pos = InStr(tmptxt, ";")
                If Pos = 0 Then GoTo DecodeError
                tmptxt2 = Left$(tmptxt, Pos - 1)
                tmptxt = Right$(tmptxt, Len(tmptxt) - Pos)
                NewData.TargetDEC = val(tmptxt2)
                
                Pos = InStr(tmptxt, ";")
                If Pos = 0 Then GoTo DecodeError
                tmptxt2 = Left$(tmptxt, Pos - 1)
                tmptxt = Right$(tmptxt, Len(tmptxt) - Pos)
                NewData.EncoderRA = val(tmptxt2)
            
                Pos = InStr(tmptxt, ";")
                If Pos = 0 Then GoTo DecodeError
                tmptxt2 = Left$(tmptxt, Pos - 1)
                NewData.EncoderDEC = val(tmptxt2)
                
                ' all data read ok - copy to alignment stars
                AlignmentStars(Index) = NewData
                ValidCount = ValidCount + 1
            Else
                GoTo DecodeError
            End If
        Next Index
    
DecodeError:
        gAlignmentStars_count = ValidCount
        
        ' now copy the alignment data to the matrix
        If gAlignmentStars_count >= 3 Then
            Call SendtoMatrix(gAlignmentStars_count)
        Else
            HC.Add_Message_Align ("Star data is less than 3, reverting to 1star align")
        End If
    End If
    
 
End Sub


Private Sub ReadPresets()
Dim Index As Integer
Dim KeyStr As String
Dim tmptxt As String
Dim AlignIni As String

    ' set up a file path for the align.ini file
    AlignIni = HC.oPersist.GetIniPath & "\ALIGN.ini"

    For Index = 0 To 9
    
        KeyStr = "[alignment_preset" & CStr(Index) & "]"
        
        tmptxt = HC.oPersist.ReadIniValueEx("name", KeyStr, AlignIni)
        If tmptxt = "" Then
            ' create a preset place holder
            tmptxt = "Empty_" & CStr(Index)
            Call HC.oPersist.WriteIniValueEx("name", tmptxt, KeyStr, AlignIni)
        End If
        
        PresetCombo.AddItem (tmptxt)
        
        tmptxt = HC.oPersist.ReadIniValueEx("STAR_COUNT", KeyStr, AlignIni)
        If tmptxt = "" Then
            ' create a preset place holder
            tmptxt = "0"
            Call HC.oPersist.WriteIniValueEx("STAR_COUNT", tmptxt, KeyStr, AlignIni)
        End If
    
    Next Index

    PresetCombo.ListIndex = GetPresetIdx
    
End Sub

Private Sub SavePresetIdx()
Dim Index As Integer
Dim tmptxt As String
Dim AlignIni As String

    ' set up a file path for the align.ini file
    AlignIni = HC.oPersist.GetIniPath & "\ALIGN.ini"
    tmptxt = CStr(PresetIdx)
    Call HC.oPersist.WriteIniValueEx("active_preset", tmptxt, "[default]", AlignIni)
    
End Sub

Private Function GetPresetIdx() As Integer
Dim Index As Integer
Dim tmptxt As String
Dim AlignIni As String

    ' set up a file path for the align.ini file
    AlignIni = HC.oPersist.GetIniPath & "\ALIGN.ini"
    tmptxt = HC.oPersist.ReadIniValueEx("active_preset", "[default]", AlignIni)
    
    If tmptxt = "" Then
        ' ini file entry doesn't exist so create one
        tmptxt = "0"
        Call HC.oPersist.WriteIniValueEx("active_preset", tmptxt, "[default]", AlignIni)
    End If
    
    GetPresetIdx = val(tmptxt)
    
    If GetPresetIdx > 10 Then
        GetPresetIdx = 0
    End If
    
End Function

'------------------------
' Public functions follow
'------------------------

Public Sub LoadAlignmentStars()
Dim idx As Integer
    ' read curent preset index from ini file
    idx = GetPresetIdx
    ' load the preset data
    Call LoadPreset(idx)
End Sub

Public Sub SaveAlignmentStars(preset As Integer, presetName As String)
Dim Index As Integer
Dim DataStr As String
Dim tmp As String
Dim key As String
Dim AlignIni As String

    ' set up a file path for the align.ini file
    AlignIni = HC.oPersist.GetIniPath & "\ALIGN.ini"

    key = "[alignment_preset" & CStr(preset) & "]"
    HC.oPersist.WriteIniValueEx "STAR_COUNT", CStr(gAlignmentStars_count), key, AlignIni
    HC.oPersist.WriteIniValueEx "NAME", presetName, key, AlignIni

    For Index = 1 To gAlignmentStars_count
        tmp = "Star" + CStr(Index)
        With AlignmentStars(Index)
            DataStr = CStr(.AlignTime) + ";" + CStr(.OrigTargetRA) + ";" + CStr(.OrigTargetDEC) + ";" + CStr(.TargetRA) + ";" + CStr(.TargetDEC) + ";" + CStr(.EncoderRA) + ";" + CStr(.EncoderDEC) + ";"
            HC.oPersist.WriteIniValueEx tmp, DataStr, key, AlignIni
        End With
    Next Index
End Sub

Private Sub SetText()
    StarEditform.Caption = HC.oLangDll.GetLangString(900)
    Label1.Caption = HC.oLangDll.GetLangString(901)
    Delete_Star_Command.Caption = HC.oLangDll.GetLangString(902)
    Goto_Command.Caption = HC.oLangDll.GetLangString(903)
    LoadCommand.Caption = HC.oLangDll.GetLangString(904)
    Save_Command.Caption = HC.oLangDll.GetLangString(905)
    PresetCombo.Text = HC.oLangDll.GetLangString(907)
    Command1.Caption = HC.oLangDll.GetLangString(906)

End Sub
