VERSION 5.00
Begin VB.Form Setupfrm 
   BackColor       =   &H00000000&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "ASCOM Setup"
   ClientHeight    =   5985
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   3465
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5985
   ScaleWidth      =   3465
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton Command11 
      Caption         =   "OK"
      BeginProperty Font 
         Name            =   "Arial Narrow"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   120
      TabIndex        =   18
      Top             =   5520
      Width           =   3255
   End
   Begin VB.PictureBox picASCOM 
      AutoSize        =   -1  'True
      BorderStyle     =   0  'None
      Height          =   840
      Left            =   120
      MouseIcon       =   "Setupfrm.frx":0000
      MousePointer    =   99  'Custom
      Picture         =   "Setupfrm.frx":0152
      ScaleHeight     =   840
      ScaleWidth      =   720
      TabIndex        =   14
      Top             =   120
      Width           =   720
   End
   Begin VB.Frame Frame2 
      BackColor       =   &H00000000&
      Caption         =   "EQMOD Port Details"
      ForeColor       =   &H000080FF&
      Height          =   2295
      Left            =   120
      TabIndex        =   11
      Top             =   1080
      Width           =   3255
      Begin VB.ComboBox lbRetry 
         Height          =   315
         ItemData        =   "Setupfrm.frx":1016
         Left            =   1320
         List            =   "Setupfrm.frx":1020
         Style           =   2  'Dropdown List
         TabIndex        =   21
         Top             =   1800
         Width           =   945
      End
      Begin VB.ComboBox lbTimeout 
         Height          =   315
         ItemData        =   "Setupfrm.frx":102A
         Left            =   1320
         List            =   "Setupfrm.frx":1034
         Style           =   2  'Dropdown List
         TabIndex        =   19
         Top             =   1320
         Width           =   945
      End
      Begin VB.ComboBox lbBaud 
         Height          =   315
         ItemData        =   "Setupfrm.frx":1044
         Left            =   1320
         List            =   "Setupfrm.frx":104E
         Style           =   2  'Dropdown List
         TabIndex        =   17
         Top             =   840
         Width           =   945
      End
      Begin VB.ComboBox lbPort 
         Height          =   315
         ItemData        =   "Setupfrm.frx":105E
         Left            =   1320
         List            =   "Setupfrm.frx":1092
         Style           =   2  'Dropdown List
         TabIndex        =   12
         Top             =   360
         Width           =   945
      End
      Begin VB.Label Label4 
         BackColor       =   &H00000000&
         Caption         =   "Retry:"
         ForeColor       =   &H000080FF&
         Height          =   225
         Left            =   240
         TabIndex        =   22
         Top             =   1800
         Width           =   930
      End
      Begin VB.Label Label3 
         BackColor       =   &H00000000&
         Caption         =   "Timeout:"
         ForeColor       =   &H000080FF&
         Height          =   225
         Left            =   240
         TabIndex        =   20
         Top             =   1320
         Width           =   930
      End
      Begin VB.Label Label2 
         BackColor       =   &H00000000&
         Caption         =   "Baud:"
         ForeColor       =   &H000080FF&
         Height          =   225
         Left            =   240
         TabIndex        =   16
         Top             =   840
         Width           =   930
      End
      Begin VB.Label Label1 
         BackColor       =   &H00000000&
         Caption         =   "Port:"
         ForeColor       =   &H000080FF&
         Height          =   225
         Left            =   240
         TabIndex        =   13
         Top             =   360
         Width           =   930
      End
   End
   Begin VB.Frame Frame1 
      BackColor       =   &H00000000&
      Caption         =   "Site Information"
      ForeColor       =   &H000080FF&
      Height          =   1980
      Left            =   120
      TabIndex        =   0
      Top             =   3480
      Width           =   3255
      Begin VB.ComboBox cbhem 
         Height          =   315
         ItemData        =   "Setupfrm.frx":10FD
         Left            =   1320
         List            =   "Setupfrm.frx":1107
         Style           =   2  'Dropdown List
         TabIndex        =   24
         Top             =   1560
         Width           =   915
      End
      Begin VB.TextBox txtLatDeg 
         Height          =   315
         Left            =   1920
         TabIndex        =   7
         Text            =   "14"
         Top             =   315
         Width           =   480
      End
      Begin VB.TextBox txtLatMin 
         Height          =   315
         Left            =   2505
         TabIndex        =   6
         Text            =   "35"
         Top             =   315
         Width           =   570
      End
      Begin VB.TextBox txtLongDeg 
         Height          =   315
         Left            =   1920
         TabIndex        =   5
         Text            =   "120"
         Top             =   720
         Width           =   480
      End
      Begin VB.TextBox txtLongMin 
         Height          =   315
         Left            =   2505
         TabIndex        =   4
         Text            =   "57"
         Top             =   720
         Width           =   570
      End
      Begin VB.ComboBox cbEW 
         Height          =   315
         ItemData        =   "Setupfrm.frx":1119
         Left            =   1320
         List            =   "Setupfrm.frx":1123
         Style           =   2  'Dropdown List
         TabIndex        =   3
         Top             =   720
         Width           =   555
      End
      Begin VB.ComboBox cbNS 
         Height          =   315
         ItemData        =   "Setupfrm.frx":112D
         Left            =   1320
         List            =   "Setupfrm.frx":1137
         Style           =   2  'Dropdown List
         TabIndex        =   2
         Top             =   315
         Width           =   555
      End
      Begin VB.TextBox txtElevation 
         Height          =   315
         Left            =   1320
         TabIndex        =   1
         Text            =   "100"
         Top             =   1125
         Width           =   885
      End
      Begin VB.Label Label8 
         BackColor       =   &H00000000&
         Caption         =   "Hemisphere:"
         ForeColor       =   &H000080FF&
         Height          =   195
         Left            =   240
         TabIndex        =   23
         Top             =   1560
         Width           =   990
      End
      Begin VB.Label Label7 
         BackColor       =   &H00000000&
         Caption         =   "Longitude:"
         ForeColor       =   &H000080FF&
         Height          =   195
         Left            =   240
         TabIndex        =   10
         Top             =   765
         Width           =   1005
      End
      Begin VB.Label Label6 
         BackColor       =   &H00000000&
         Caption         =   "Latitude:"
         ForeColor       =   &H000080FF&
         Height          =   225
         Left            =   240
         TabIndex        =   9
         Top             =   360
         Width           =   930
      End
      Begin VB.Label Label5 
         BackColor       =   &H00000000&
         Caption         =   "Elevation (m):"
         ForeColor       =   &H000080FF&
         Height          =   195
         Left            =   240
         TabIndex        =   8
         Top             =   1155
         Width           =   990
      End
   End
   Begin VB.Label MainLabel 
      BackColor       =   &H00000080&
      Caption         =   "EQMOD ASCOM SETUP"
      BeginProperty Font 
         Name            =   "Comic Sans MS"
         Size            =   14.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   855
      Left            =   960
      TabIndex        =   15
      Top             =   120
      Width           =   2415
   End
End
Attribute VB_Name = "Setupfrm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'---------------------------------------------------------------------
' Copyright  2006 Raymund Sarmiento
'
' Permission is hereby granted to use this Software for any purpose
' including combining with commercial products, creating derivative
' works, and redistribution of source or binary code, without
' limitation or consideration. Any redistributed copies of this
' Software must include the above Copyright Notice.
'
' THIS SOFTWARE IS PROVIDED "AS IS". THE AUTHOR OF THIS CODE MAKES NO
' WARRANTIES REGARDING THIS SOFTWARE, EXPRESS OR IMPLIED, AS TO ITS
' SUITABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
'---------------------------------------------------------------------
'
' Setupfrm.frm - ASCOM EQMOD Setup form
'
'
'
' Written:  07-Oct-06   Raymund Sarmiento
'
' Edits:
'
' When      Who     What
' --------- ---     --------------------------------------------------
' 04-Nov-06 rcs     Initial edit for EQ Mount Driver Function Prototype
' 14-Nov-06 rcs     Bug Fix on OK button - gHemispher changed to gHemisphere
' 20-Nov-06 rcs     Bug Fix on Elevation value not being saved to the Registry
' 25-Nov-06 rcs     Add Regional Setting Functions
'---------------------------------------------------------------------
'
'
'  SYNOPSIS:
'
'  This is a demonstration of a EQ6/ATLAS/EQG direct stepper motor control access
'  using the EQCONTRL.DLL driver code.
'
'  File EQCONTROL.bas contains all the function prototypes of all subroutines
'  encoded in the EQCONTRL.dll
'
'  The EQ6CONTRL.DLL simplifies execution of the Mount controller board stepper
'  commands.
'
'  The mount circuitry needs to be modified for this test program to work.
'  Circuit details can be found at http://www.freewebs.com/eq6mod/
'

'  DISCLAIMER:

'  You can use the information on this site COMPLETELY AT YOUR OWN RISK.
'  The modification steps and other information on this site is provided
'  to you "AS IS" and WITHOUT WARRANTY OF ANY KIND, express, statutory,
'  implied or otherwise, including without limitation any warranty of
'  merchantability or fitness for any particular or intended purpose.
'  In no event the author will  be liable for any direct, indirect,
'  punitive, special, incidental or consequential damages or loss of any
'  kind whether or not the author  has been advised of the possibility
'  of such loss.

'  WARNING:

'  Circuit modifications implemented on your setup could invalidate
'  any warranty that you may have with your product. Use this
'  information at your own risk. The modifications involve direct
'  access to the stepper motor controls of your mount. Any "mis-control"
'  or "mis-command"  / "invalid parameter" or "garbage" data sent to the
'  mount could accidentally activate the stepper motors and allow it to
'  rotate "freely" damaging any equipment connected to your mount.
'  It is also possible that any garbage or invalid data sent to the mount
'  could cause its firmware to generate mis-steps pulse sequences to the
'  motors causing it to overheat. Make sure that you perform the
'  modifications and testing while there is no physical "load" or
'  dangling wires on your mount. Be sure to disconnect the power once
'  this event happens or if you notice any unusual sound coming from
'  the motor assembly.
'
'  CREDITS:
'
'  Portions of the information on this code should be attributed
'  to Mr. John Archbold from his initial observations and analysis
'  of the interface circuits and of the ASCII data stream between
'  the Hand Controller (HC) and the Go To Controller.
'
Option Explicit

Private s_Profile As DriverHelper.Profile
Private Const sID As String = "EQMOD.Telescope"
Private Const sDESC As String = "EQMOD ASCOM Scope Driver"

Private Sub Command11_Click()

    HC.oPersist.WriteIniValue "Port", CStr(Setupfrm.lbPort.Text)
    HC.oPersist.WriteIniValue "Baud", CStr(Setupfrm.lbBaud.Text)
    HC.oPersist.WriteIniValue "Timeout", CStr(Setupfrm.lbTimeout.Text)
    HC.oPersist.WriteIniValue "Retry", CStr(Setupfrm.lbRetry.Text)
    
    HC.oPersist.WriteIniValue "LatitudeMin", CStr(Setupfrm.txtLatMin.Text)
    HC.oPersist.WriteIniValue "LatitudeDeg", CStr(Setupfrm.txtLatDeg.Text)
    HC.oPersist.WriteIniValue "LatitudeNS", CStr(Setupfrm.cbNS.ListIndex)
    HC.oPersist.WriteIniValue "LongitudeDeg", CStr(Setupfrm.txtLongDeg.Text)
    HC.oPersist.WriteIniValue "LongitudeMin", CStr(Setupfrm.txtLongMin.Text)
    HC.oPersist.WriteIniValue "LongitudeEW", CStr(Setupfrm.cbEW.ListIndex)
    HC.oPersist.WriteIniValue "HemisphereNS", CStr(Setupfrm.cbhem.ListIndex)
    HC.oPersist.WriteIniValue "Elevation", CStr(Setupfrm.txtElevation.Text)
      
          
    HC.txtLatMin.Text = Setupfrm.txtLatMin.Text
    HC.txtLatDeg.Text = Setupfrm.txtLatDeg.Text
    HC.cbNS.ListIndex = Setupfrm.cbNS.ListIndex
    HC.txtLongDeg.Text = Setupfrm.txtLongDeg.Text
    HC.txtLongMin.Text = Setupfrm.txtLongMin.Text
    HC.cbEW.ListIndex = Setupfrm.cbEW.ListIndex
    HC.cbhem.ListIndex = Setupfrm.cbhem.ListIndex
    HC.txtElevation.Text = Setupfrm.txtElevation.Text
   
    gLongitude = CDbl(EQFixNum(Setupfrm.txtLongDeg)) + (CDbl(EQFixNum(Setupfrm.txtLongMin)) / 60#)
    If Setupfrm.cbEW.Text = HC.oLangDll.GetLangString(115) Then gLongitude = -gLongitude  ' W is neg
    
    gLatitude = CDbl(EQFixNum(Setupfrm.txtLatDeg)) + (CDbl(EQFixNum(Setupfrm.txtLatMin)) / 60#)
    If Setupfrm.cbNS.Text = HC.oLangDll.GetLangString(116) Then gLatitude = -gLatitude
    gElevation = CDbl(EQFixNum(Setupfrm.txtElevation))
    
    If Setupfrm.cbhem.Text = HC.oLangDll.GetLangString(1110) Then
        gHemisphere = 0
    Else
        gHemisphere = 1
    End If
       
       
    gPort = Setupfrm.lbPort.Text
    gBaud = val(Setupfrm.lbBaud.Text)
    gTimeout = val(Setupfrm.lbTimeout.Text)
    gRetry = val(Setupfrm.lbRetry.Text)
     
    Unload Me
End Sub




Private Sub Form_Load()

    
    
    Dim tmptxt As String
    
    Call SetText
      
    EnableCloseButton Me.hWnd, False
          
    Setupfrm.cbNS.ListIndex = 0
    Setupfrm.cbEW.ListIndex = 0
    Setupfrm.cbhem.ListIndex = 0
 
    Set s_Profile = New DriverHelper.Profile
 
    tmptxt = HC.oPersist.ReadIniValue("Port")
    If tmptxt <> "" Then Setupfrm.lbPort.Text = tmptxt
   
    tmptxt = HC.oPersist.ReadIniValue("Baud")
    If tmptxt <> "" Then Setupfrm.lbBaud.Text = tmptxt
    
    tmptxt = HC.oPersist.ReadIniValue("Timeout")
    If tmptxt <> "" Then Setupfrm.lbTimeout.Text = tmptxt
    
    tmptxt = HC.oPersist.ReadIniValue("Retry")
    If tmptxt <> "" Then Setupfrm.lbRetry.Text = tmptxt
   
    tmptxt = HC.oPersist.ReadIniValue("LongitudeDeg")
    If tmptxt <> "" Then Setupfrm.txtLongDeg.Text = tmptxt
     
    tmptxt = HC.oPersist.ReadIniValue("LongitudeMin")
    If tmptxt <> "" Then Setupfrm.txtLongMin.Text = tmptxt
     
    tmptxt = HC.oPersist.ReadIniValue("LongitudeEW")
    If tmptxt <> "" Then Setupfrm.cbEW.ListIndex = val(tmptxt)
     
    tmptxt = HC.oPersist.ReadIniValue("LatitudeDeg")
    If tmptxt <> "" Then Setupfrm.txtLatDeg.Text = tmptxt
   
    tmptxt = HC.oPersist.ReadIniValue("LatitudeMin")
    If tmptxt <> "" Then Setupfrm.txtLatMin.Text = tmptxt
     
    tmptxt = HC.oPersist.ReadIniValue("LatitudeNS")
    If tmptxt <> "" Then Setupfrm.cbNS.ListIndex = val(tmptxt)
     
    tmptxt = HC.oPersist.ReadIniValue("Elevation")
    If tmptxt <> "" Then Setupfrm.txtElevation = tmptxt
     
    tmptxt = HC.oPersist.ReadIniValue("HemisphereNS")
    If tmptxt <> "" Then Setupfrm.cbhem.ListIndex = val(tmptxt)
    


End Sub

Private Sub SetText()
    Setupfrm.Caption = HC.oLangDll.GetLangString(700)
    MainLabel.Caption = HC.oLangDll.GetLangString(701)
    Frame2.Caption = HC.oLangDll.GetLangString(702)
    Label1.Caption = HC.oLangDll.GetLangString(703)
    Label2.Caption = HC.oLangDll.GetLangString(704)
    Label3.Caption = HC.oLangDll.GetLangString(705)
    Label4.Caption = HC.oLangDll.GetLangString(706)
    
    Frame1.Caption = HC.oLangDll.GetLangString(126)
    Label6.Caption = HC.oLangDll.GetLangString(127)
    Label7.Caption = HC.oLangDll.GetLangString(128)
    Label5.Caption = HC.oLangDll.GetLangString(129)
    Label8.Caption = HC.oLangDll.GetLangString(130)
    
    Command11.Caption = HC.oLangDll.GetLangString(609)
End Sub

