Attribute VB_Name = "LaunchApp"
Option Explicit

Public Type RECT
  Left    As Long
  Top     As Long
  Right   As Long
  Bottom  As Long
End Type

Public Type POINTAPI
  x       As Long
  y       As Long
End Type

Public Type WINDOWPLACEMENT
  Length            As Long
  flags             As Long
  showCmd           As Long
  ptMinPosition     As POINTAPI
  ptMaxPosition     As POINTAPI
  rcNormalPosition  As RECT
End Type

Public Const SW_SHOWNORMAL = 1
Public Const SW_SHOWMINIMIZED = 2
Public Const SW_SHOWMAXIMIZED = 3
Public Const SW_SHOWNOACTIVATE = 4

Private Declare Function BringWindowToTop Lib "user32" _
  (ByVal hwnd As Long) As Long

Private Declare Function FindWindow Lib "user32" _
   Alias "FindWindowA" _
  (ByVal lpClassName As String, _
   ByVal lpWindowName As String) As Long
   
Private Declare Function GetWindowPlacement Lib "user32" _
   (ByVal hwnd As Long, lpwndpl As WINDOWPLACEMENT) As Long

Private Declare Function SetForegroundWindow Lib "user32" _
   (ByVal hwnd As Long) As Long

Private Declare Function SetWindowPlacement Lib "user32" _
   (ByVal hwnd As Long, lpwndpl As WINDOWPLACEMENT) As Long

Public Sub LaunchUtilityApp(Index As Integer)
Dim tmptxt As String
Dim nofile As Boolean
Dim THandle As Long
Dim processId As Long
Dim iret As Long
Dim inistr As String
Dim strwnd As String

On Error GoTo launcherr:

    Select Case Index
        Case 0
            inistr = "TOUR_EXE"
            strwnd = "eqtour"
        Case 1
            inistr = "MOSAIC_EXE"
            strwnd = "eqmosaic"
    End Select

    THandle = FindWindow(vbNullString, strwnd)
    If THandle <> 0 Then
        ' application already open - bring to to focus
        RestoreWindow THandle
    Else
        nofile = False
        ' get application path
        tmptxt = HC.oPersist.ReadIniValue(inistr)
        If tmptxt = "" Then
            nofile = True
        Else
            If Dir(tmptxt) = "" Then
                nofile = True
            End If
        End If
        
        ' no application path so let user assign one
        If nofile Then
            FileDlg.filter = strwnd & ".exe"
            FileDlg.Show (1)
            tmptxt = FileDlg.filename
            If tmptxt <> "" Then
                If Dir(tmptxt) <> "" Then
                    Call HC.oPersist.WriteIniValue(inistr, tmptxt)
                    nofile = False
                Else
                    nofile = True
                End If
            End If
        End If
        
        If Not nofile Then
            ' open application
            processId = Shell(tmptxt, vbNormalFocus)
            If processId <> 0 Then
                ' bring it to the top
                THandle = FindWindow(vbEmpty, strwnd)
                If THandle <> 0 Then
                   iret = BringWindowToTop(THandle)
                End If
            End If
        End If
    End If
    GoTo endlaunch
    
    
launcherr:
    ' been an error of some sort! - remove infile entry
    Call HC.oPersist.WriteIniValue(inistr, "")

endlaunch:
End Sub


Private Sub RestoreWindow(hWndCtlApp As Long)

Dim currWinP As WINDOWPLACEMENT
    
    'prepare the WINDOWPLACEMENT type
    currWinP.Length = Len(currWinP)
    If GetWindowPlacement(hWndCtlApp, currWinP) > 0 Then
        'determine the window state
        If currWinP.showCmd = SW_SHOWMINIMIZED Then
            'minimized, so restore
            currWinP.Length = Len(currWinP)
            currWinP.flags = 0&
            currWinP.showCmd = SW_SHOWNORMAL
            Call SetWindowPlacement(hWndCtlApp, currWinP)
        Else
            'on screen, so assure visible
            Call SetForegroundWindow(hWndCtlApp)
            Call BringWindowToTop(hWndCtlApp)
        End If
    End If

End Sub

