Attribute VB_Name = "Common"
'---------------------------------------------------------------------
' Copyright  2006 Raymund Sarmiento
'
' Permission is hereby granted to use this Software for any purpose
' including combining with commercial products, creating derivative
' works, and redistribution of source or binary code, without
' limitation or consideration. Any redistributed copies of this
' Software must include the above Copyright Notice.
'
' THIS SOFTWARE IS PROVIDED "AS IS". THE AUTHOR OF THIS CODE MAKES NO
' WARRANTIES REGARDING THIS SOFTWARE, EXPRESS OR IMPLIED, AS TO ITS
' SUITABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
'---------------------------------------------------------------------
'
' Common.bas - Common functions for EQMOD ASCOM driver
'
'
' Written:  07-Oct-06   Raymund Sarmiento
'
' Edits:
'
' When      Who     What
' --------- ---     --------------------------------------------------
' 04-Nov-06 rcs     Initial edit for EQ Mount Driver Function Prototype
' 15-Nov-06 rcs     Fix bug on OnestarAlign Message Center display (discovered by Sander)
' 21-Nov-06 rcs     Append RA GOTO Compenstation to minimize discrepancy
' 25-Nov-06 rcs     Add Regional Setting Functions
' 01-Dec-06 rcs     Add GPS Function and Autoguider port save
' 04-Feb-07 rcs     Added function to stop a GOTO through ASCOM property call
' 03-Apr-07 rcs     Add RA Slew Limits
' 06-Apr-07 rcs     Added SyncLimit and fixed F/W lag processing in Moveaxis
' 14-Jul-07         Add support for other boards
' 29-Jul-07 cs      Slew rate presets read & write.
' 31-Jul-07 cs      Fixed rates read/write
' 13-Aug-07 cs      Language dll stuff
' 14-Aug-07 cs      Sites list
' 05-Oct-07 cs      EQPecMoveAxis, readCustomRa, WriteCustomRa added
'---------------------------------------------------------------------
'
'  SYNOPSIS:
'
'  This is a demonstration of a EQ6/ATLAS/EQG direct stepper motor control access
'  using the EQCONTRL.DLL driver code.
'
'  File EQCONTROL.bas contains all the function prototypes of all subroutines
'  encoded in the EQCONTRL.dll
'
'  The EQ6CONTRL.DLL simplifies execution of the Mount controller board stepper
'  commands.
'
'  The mount circuitry needs to be modified for this test program to work.
'  Circuit details can be found at http://www.freewebs.com/eq6mod/
'

'  DISCLAIMER:

'  You can use the information on this site COMPLETELY AT YOUR OWN RISK.
'  The modification steps and other information on this site is provided
'  to you "AS IS" and WITHOUT WARRANTY OF ANY KIND, express, statutory,
'  implied or otherwise, including without limitation any warranty of
'  merchantability or fitness for any particular or intended purpose.
'  In no event the author will  be liable for any direct, indirect,
'  punitive, special, incidental or consequential damages or loss of any
'  kind whether or not the author  has been advised of the possibility
'  of such loss.

'  WARNING:

'  Circuit modifications implemented on your setup could invalidate
'  any warranty that you may have with your product. Use this
'  information at your own risk. The modifications involve direct
'  access to the stepper motor controls of your mount. Any "mis-control"
'  or "mis-command"  / "invalid parameter" or "garbage" data sent to the
'  mount could accidentally activate the stepper motors and allow it to
'  rotate "freely" damaging any equipment connected to your mount.
'  It is also possible that any garbage or invalid data sent to the mount
'  could cause its firmware to generate mis-steps pulse sequences to the
'  motors causing it to overheat. Make sure that you perform the
'  modifications and testing while there is no physical "load" or
'  dangling wires on your mount. Be sure to disconnect the power once
'  this event happens or if you notice any unusual sound coming from
'  the motor assembly.
'
'  CREDITS:
'
'  Portions of the information on this code should be attributed
'  to Mr. John Archbold from his initial observations and analysis
'  of the interface circuits and of the ASCII data stream between
'  the Hand Controller (HC) and the Go To Controller.
'
Option Explicit

Const HWND_TOPMOST = -1
Const HWND_NOTTOPMOST = -2
Const SWP_NOMOVE = &H2
Const SWP_NOSIZE = &H1

Public oProfile As DriverHelper.Profile
Public Const oID As String = "EQMOD.Telescope"
Public m_telescope As Telescope
Public gPresetSlewRates(1 To 10) As Integer
Public gRateButtons(1 To 4) As Integer
Public gPresetSlewRatesCount As Integer
Public gCurrentRatePreset As Integer
Public ClientCount As Integer
Public LanguageDll As String
Public gInitResult As Double

Private Const oDESC As String = "EQMOD ASCOM Scope Driver"


Private Const SC_CLOSE As Long = &HF060&
Private Const MIIM_STATE As Long = &H1&
Private Const MIIM_ID As Long = &H2&
Private Const MFS_GRAYED As Long = &H3&
Private Const WM_NCACTIVATE As Long = &H86

Private Type MENUITEMINFO
    cbSize As Long
    fMask As Long
    fType As Long
    fState As Long
    wID As Long
    hSubMenu As Long
    hbmpChecked As Long
    hbmpUnchecked As Long
    dwItemData As Long
    dwTypeData As String
    cch As Long
End Type

Public Declare Function BeepAPI Lib "kernel32" Alias "Beep" (ByVal dwFrequency _
    As Long, ByVal dwMilliseconds As Long) As Long
    

Private Declare Function GetSystemMenu Lib "user32" ( _
    ByVal hwnd As Long, ByVal bRevert As Long) As Long

Private Declare Function GetMenuItemInfo Lib "user32" Alias _
    "GetMenuItemInfoA" (ByVal hMenu As Long, ByVal un As Long, _
    ByVal b As Boolean, lpMenuItemInfo As MENUITEMINFO) As Long

Private Declare Function SetMenuItemInfo Lib "user32" Alias _
    "SetMenuItemInfoA" (ByVal hMenu As Long, ByVal un As Long, _
    ByVal bool As Boolean, lpcMenuItemInfo As MENUITEMINFO) As Long

Private Declare Function SendMessage Lib "user32" Alias _
    "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, _
    ByVal wParam As Long, lParam As Any) As Long

Private Declare Function IsWindow Lib "user32" _
    (ByVal hwnd As Long) As Long


' Locale Info for Regional Settings processing
    

Declare Function GetLocaleInfo Lib "kernel32" Alias "GetLocaleInfoA" (ByVal Locale As Long, ByVal LCType As Long, ByVal lpLCData As String, ByVal cchData As Long) As Long

Declare Function GetUserDefaultLCID% Lib "kernel32" ()

' Constants used

Public Const LOCALE_SDECIMAL = &HE


Private Declare Function SetWindowPos Lib "user32" _
         (ByVal hwnd As Long, ByVal hWndInsertAfter As Long, ByVal x As Long, ByVal y As Long, _
          ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long



Public Sub PutWindowOnTop(pFrm As Form)
  Dim lngWindowPosition As Long
  
  lngWindowPosition = SetWindowPos(pFrm.hwnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE Or SWP_NOSIZE)

End Sub
Public Sub PutWindowNormal(pFrm As Form)
  Dim lngWindowPosition As Long
  
  lngWindowPosition = SetWindowPos(pFrm.hwnd, HWND_NOTTOPMOST, 0, 0, 0, 0, SWP_NOMOVE Or SWP_NOSIZE)

End Sub

Public Function CheckMount(openstat As Double)

Dim i As Long

    If openstat = 5 Then
    
         i = EQ_GetTotal360microstep(0)
         
         If i >= &H1000000 Then
         
            HC.Add_Message (HC.oLangDll.GetLangString(5033))
            
            CheckMount = openstat  ' Exit as Unknown mount
            Exit Function
            
         End If
         
         If i <> EQ_GetTotal360microstep(1) Then        ' Both axis does not have equal step counts
         
            HC.Add_Message (HC.oLangDll.GetLangString(5034))
         
            CheckMount = openstat ' Exit as unknown mount
            Exit Function
            
         End If
    
         gTot_step = i
    
         Select Case i
         
                Case 9024000:  'TYPE1 Mounts
                        
                        gDECEncoder_Home_pos = DECEncoder_Home_pos_const '&HA26C80
                        gEQ_MAXSYNC = EQ_MAXSYNC_Const             ' 88B80
                        
                        If gRA_Limit_East <> 0 And gRA_Limit_West <> 0 Then
                            gRA_Limit_East = &H5D5500                  ' Set RA Limit West Side
                            gRA_Limit_West = &HA2AB00                  ' Set RA Limit East Side
                        End If
                        
                        If gHemisphere = 0 Then
    
                            HC.Label35.Caption = printhex(gRA_Limit_West)
                            HC.Label36.Caption = printhex(gRA_Limit_East)
    
                        Else
    
                            HC.Label36.Caption = printhex(gRA_Limit_West)
                            HC.Label35.Caption = printhex(gRA_Limit_East)
    
                        End If
                        
                        CheckMount = EQ_OK
                        Exit Function

                Case 4505600:   'TYPE2 Mounts
              
                        gDECEncoder_Home_pos = &H913000            ' Set Home Pos for this version
                        gEQ_MAXSYNC = &H445C0
                        gSidFlag = openstat                        ' Disable RA/DEC Emulation
                
                        If gRA_Limit_East <> 0 And gRA_Limit_West <> 0 Then
                            gRA_Limit_East = &H6EAA80                  ' Set RA Limit West Side
                            gRA_Limit_West = &H915580                  ' Set RA Limit East Side
                        End If

                        If gHemisphere = 0 Then
    
                            HC.Label35.Caption = printhex(gRA_Limit_West)
                            HC.Label36.Caption = printhex(gRA_Limit_East)
    
                        Else
    
                            HC.Label36.Caption = printhex(gRA_Limit_West)
                            HC.Label35.Caption = printhex(gRA_Limit_East)
    
                        End If
                        
                        CheckMount = EQ_OK
                        Exit Function

                Case 4576000:   'TYPE3 Mounts
              
                        gDECEncoder_Home_pos = &H9174C0            ' totstep/4 + Homepos
                        gEQ_MAXSYNC = &H45838                      ' 80640 * arcsec/step
                        gSidFlag = openstat                        ' Disable RA/DEC Emulation
                
                        If gRA_Limit_East <> 0 And gRA_Limit_West <> 0 Then
                            gRA_Limit_East = &H6E5F8F                  ' Set RA Limit West Side
                            gRA_Limit_West = &H91A071                  ' homepos + 90.88degrees of step
                        End If

                        If gHemisphere = 0 Then
    
                            HC.Label35.Caption = printhex(gRA_Limit_West)
                            HC.Label36.Caption = printhex(gRA_Limit_East)
    
                        Else
    
                            HC.Label36.Caption = printhex(gRA_Limit_West)
                            HC.Label35.Caption = printhex(gRA_Limit_East)
    
                        End If
                        
                        CheckMount = EQ_OK
                        Exit Function


                Case Else
                    CheckMount = openstat
                    Exit Function
                End Select

    Else
    
    
        ' Use default settings
    
        gDECEncoder_Home_pos = DECEncoder_Home_pos_const
        gEQ_MAXSYNC = EQ_MAXSYNC_Const
                        
        If gRA_Limit_East <> 0 And gRA_Limit_West <> 0 Then
            gRA_Limit_East = &H5D5500                  ' Set RA Limit West Side
            gRA_Limit_West = &HA2AB00                  ' Set RA Limit East Side
        End If
        
        If gHemisphere = 0 Then
    
            HC.Label35.Caption = printhex(gRA_Limit_West)
            HC.Label36.Caption = printhex(gRA_Limit_East)
    
        Else
    
            HC.Label36.Caption = printhex(gRA_Limit_West)
            HC.Label35.Caption = printhex(gRA_Limit_East)
    
        End If
    
        CheckMount = openstat
        Exit Function
        
    End If

End Function


' Function to fix the Numerical string to match the  Regional Settings

Public Function EQFixNum(numstring As String) As String

Dim Symbol As String
Dim iRet1 As Long
Dim iRet2 As Long
Dim lpLCDataVar As String
Dim pos As Integer
Dim Locale As Long
Dim tmpstring As String


    If numstring = "" Then
        EQFixNum = 0
        Exit Function
    End If

    ' Get the Local ID
     Locale = GetUserDefaultLCID()

    ' Get the Local info
   iRet1 = GetLocaleInfo(Locale, LOCALE_SDECIMAL, lpLCDataVar, 0)

   
   ' Get the symbol from the Local info
   Symbol = String$(iRet1, 0)
   iRet2 = GetLocaleInfo(Locale, LOCALE_SDECIMAL, Symbol, iRet1)
   pos = InStr(Symbol, Chr$(0))
   If pos > 0 Then Symbol = Left$(Symbol, pos - 1)

   tmpstring = Replace(numstring, ".", Symbol)

   If IsNumeric(tmpstring) = False Then
        tmpstring = Replace(numstring, ",", Symbol)
        If IsNumeric(tmpstring) = False Then
            MsgBox ("EQMOD: Invalid String Format " & tmpstring)
            tmpstring = "-1"
        End If
   End If
   
   EQFixNum = tmpstring

End Function

Public Function EQFixLocale(numstring As String) As String

Dim Symbol As String
Dim iRet1 As Long
Dim iRet2 As Long
Dim lpLCDataVar As String
Dim pos As Integer
Dim Locale As Long
Dim tmpstring As String

    ' Get the Local ID
     Locale = GetUserDefaultLCID()

    ' Get the Local info
   iRet1 = GetLocaleInfo(Locale, LOCALE_SDECIMAL, lpLCDataVar, 0)

   
   ' Get the symbol from the Local info
   Symbol = String$(iRet1, 0)
   iRet2 = GetLocaleInfo(Locale, LOCALE_SDECIMAL, Symbol, iRet1)
   pos = InStr(Symbol, Chr$(0))
   If pos > 0 Then Symbol = Left$(Symbol, pos - 1)

   tmpstring = Replace(numstring, ".", Symbol)
   tmpstring = Replace(tmpstring, ",", Symbol)

   EQFixLocale = tmpstring

End Function

Public Function EnableCloseButton(ByVal hwnd As Long, Enable As Boolean) _
                                                                As Integer
    Const xSC_CLOSE As Long = -10

    ' Check that the window handle passed is valid
    
    EnableCloseButton = -1
    If IsWindow(hwnd) = 0 Then Exit Function
    
    ' Retrieve a handle to the window's system menu
    
    Dim hMenu As Long
    hMenu = GetSystemMenu(hwnd, 0)
    
    ' Retrieve the menu item information for the close menu item/button
    
    Dim MII As MENUITEMINFO
    MII.cbSize = Len(MII)
    MII.dwTypeData = String(80, 0)
    MII.cch = Len(MII.dwTypeData)
    MII.fMask = MIIM_STATE
    
    If Enable Then
        MII.wID = xSC_CLOSE
    Else
        MII.wID = SC_CLOSE
    End If
    
    EnableCloseButton = -0
    If GetMenuItemInfo(hMenu, MII.wID, False, MII) = 0 Then Exit Function
    
    ' Switch the ID of the menu item so that VB can not undo the action itself
    
    Dim lngMenuID As Long
    lngMenuID = MII.wID
    
    If Enable Then
        MII.wID = SC_CLOSE
    Else
        MII.wID = xSC_CLOSE
    End If
    
    MII.fMask = MIIM_ID
    EnableCloseButton = -2
    If SetMenuItemInfo(hMenu, lngMenuID, False, MII) = 0 Then Exit Function
    
    ' Set the enabled / disabled state of the menu item
    
    If Enable Then
        MII.fState = (MII.fState Or MFS_GRAYED)
        MII.fState = MII.fState - MFS_GRAYED
    Else
        MII.fState = (MII.fState Or MFS_GRAYED)
    End If
    
    MII.fMask = MIIM_STATE
    EnableCloseButton = -3
    If SetMenuItemInfo(hMenu, MII.wID, False, MII) = 0 Then Exit Function
    
    ' Activate the non-client area of the window to update the titlebar, and
    ' draw the close button in its new state.
    
    SendMessage hwnd, WM_NCACTIVATE, True, 0
    
    EnableCloseButton = 0
    
End Function

Public Sub Main()

Set oProfile = New DriverHelper.Profile
'Dim m_telescope As Telescope
Set m_telescope = New Telescope

oProfile.DeviceType = "Telescope"

If App.StartMode = vbSModeStandalone Then
        MsgBox "This is an ASCOM driver. It cannot be run stand-alone", _
                (vbOKOnly + vbCritical + vbMsgBoxSetForeground), App.FileDescription
        Exit Sub
   End If


End Sub

'Routine to Slew the mount to target location
'RAOnly flag when active only activates the RA Motor

Public Sub radecAsyncSlew(ByVal RAOnly As Boolean)

Dim targetRAEncoder As Double
Dim targetDECEncoder As Double
Dim currentRAEncoder As Double
Dim currentDECEncoder As Double
Dim tmpcoord As Coordt

Dim DeltaRAStep As Long
Dim DeltaDECStep As Long

Dim RASlowdown As Long
Dim DECSlowdown As Long

Dim tRA As Double
Dim tha As Double
Dim tPier As Double

      'Make sure non of the motors are running, if yes then stop it
         
      eqres = EQ_MotorStop(0)
      eqres = EQ_MotorStop(1)
      
      'Wait for motor stop , Need to add timeout routines here
      
'      Do
'         DoEvents
'      Loop While ((gRAStatus And EQ_MOTORBUSY) + (gDECStatus And EQ_MOTORBUSY)) <> 0


        Do
            eqres = EQ_GetMotorStatus(0)
            If (eqres = EQ_NOTINITIALIZED) Or (eqres = EQ_COMNOTOPEN) Or (eqres = EQ_COMTIMEOUT) Then GoTo SL01
       
        Loop While (eqres And EQ_MOTORBUSY) <> 0

SL01:

        Do
            eqres = EQ_GetMotorStatus(1)
            If (eqres = EQ_NOTINITIALIZED) Or (eqres = EQ_COMNOTOPEN) Or (eqres = EQ_COMTIMEOUT) Then GoTo SL02
       
        Loop While (eqres And EQ_MOTORBUSY) <> 0

SL02:



      tha = RangeHA(gTargetRA - EQnow_lst(gLongitude * DEG_RAD))
  
      If tha < 0 Then
    
        If gHemisphere = 0 Then
            tPier = 1
        Else
            tPier = 0
        End If
        tRA = Range24(gTargetRA - 12)
      
      Else
        
        If gHemisphere = 0 Then
            tPier = 0
        Else
            tPier = 1
        End If
        
        tRA = gTargetRA
      
      End If

    'Compute for Target RA/DEC Encoder

     targetRAEncoder = Get_RAEncoderfromRA(tRA, 0, gLongitude, gRAEncoder_Zero_pos, gTot_RA, gHemisphere)
     targetDECEncoder = Get_DECEncoderfromDEC(gTargetDec, tPier, gDECEncoder_Zero_pos, gTot_DEC, gHemisphere)
          
    
     If gThreeStarEnable = False Then
        gSelectStar = 0
        currentRAEncoder = Delta_RA_Map(EQ_GetMotorValues(0))
        currentDECEncoder = Delta_DEC_Map(EQ_GetMotorValues(1))
     Else
        
        If HC.ListAlignMode.ListIndex = 2 Then
        
          tmpcoord = DeltaSyncReverse_Matrix_Map(targetRAEncoder - gRASync01, targetDECEncoder - gDECSync01)
        
          targetRAEncoder = tmpcoord.x
          targetDECEncoder = tmpcoord.y
          currentRAEncoder = EQ_GetMotorValues(0)
          currentDECEncoder = EQ_GetMotorValues(1)
        
        Else
          
          If HC.ListAlignMode.ListIndex = 1 Then
          
            tmpcoord = Delta_Matrix_Map(targetRAEncoder - gRASync01, targetDECEncoder - gDECSync01)
          
            targetRAEncoder = tmpcoord.x
            targetDECEncoder = tmpcoord.y
            currentRAEncoder = EQ_GetMotorValues(0)
            currentDECEncoder = EQ_GetMotorValues(1)
          
          Else
          
            tmpcoord = Delta_Matrix_Map(targetRAEncoder - gRASync01, targetDECEncoder - gDECSync01)
            
            If tmpcoord.f = 0 Then
            
                tmpcoord = DeltaSyncReverse_Matrix_Map(targetRAEncoder - gRASync01, targetDECEncoder - gDECSync01)
            
            End If
            
            targetRAEncoder = tmpcoord.x
            targetDECEncoder = tmpcoord.y
            currentRAEncoder = EQ_GetMotorValues(0)
            currentDECEncoder = EQ_GetMotorValues(1)
          
          End If
          
        End If
    
        If NStar_debug.Visible Then
            Call NStar_debug.draw_gotodot(targetRAEncoder - gRASync01, targetDECEncoder - gDECSync01)
        End If
    
    
     End If
     
     DeltaRAStep = Abs(targetRAEncoder - currentRAEncoder)
     DeltaDECStep = Abs(targetDECEncoder - currentDECEncoder)
               
               
    ' Compensate for the smallest discrepancy after the final slew
         
     If gTrackingStatus > 0 Then
        If targetRAEncoder > currentRAEncoder Then
            If gHemisphere = 0 Then
                DeltaRAStep = DeltaRAStep + gRA_Compensate
            Else
                DeltaRAStep = DeltaRAStep - gRA_Compensate
            End If
        Else
            If gHemisphere = 0 Then
                DeltaRAStep = DeltaRAStep - gRA_Compensate
            Else
                DeltaRAStep = DeltaRAStep + gRA_Compensate
            End If
        End If
               
        If DeltaRAStep < 0 Then DeltaRAStep = 0
        
     End If
               
     RASlowdown = GetSlowdown(DeltaRAStep)
     DECSlowdown = GetSlowdown(DeltaDECStep)
  
     'Execute the actual slew
         
     If DeltaRAStep <> 0 Then
      If targetRAEncoder > currentRAEncoder Then
        eqres = EQ_StartMoveMotor(0, 0, 0, DeltaRAStep, RASlowdown)
      Else
        eqres = EQ_StartMoveMotor(0, 0, 1, DeltaRAStep, RASlowdown)
      End If
     End If
     
      If (Not RAOnly) And (DeltaDECStep <> 0) Then
      
        If targetDECEncoder > currentDECEncoder Then
            eqres = EQ_StartMoveMotor(1, 0, 0, DeltaDECStep, DECSlowdown)
        Else
            eqres = EQ_StartMoveMotor(1, 0, 1, DeltaDECStep, DECSlowdown)
        End If
        
      End If

     ' Activate Asynchronous Slew Monitoring Routine

     gSlewStatus = True
     gRAStatus = EQ_MOTORBUSY
     gDECStatus = EQ_MOTORBUSY
     gRAStatus_slew = False
     HC.GotoTimer.Enabled = True
     
 End Sub

Public Sub ParkHome()

    Dim currentdecpos As Double
    Dim currentrapos As Double
    Dim i As Long
    Dim j As Long

    eqres = EQ_MotorStop(0)          ' Stop RA Motor
    If eqres <> EQ_OK Then
            GoTo Endhome
    End If
    eqres = EQ_MotorStop(1)          ' Stop DEC Motor
    If eqres <> EQ_OK Then
            GoTo Endhome
    End If

    'Wait until RA motor is stable

    Do
       eqres = EQ_GetMotorStatus(0)
       If (eqres = EQ_NOTINITIALIZED) Or (eqres = EQ_COMNOTOPEN) Or (eqres = EQ_COMTIMEOUT) Then
            GoTo Endhome
       End If
    Loop While (eqres And EQ_MOTORBUSY) <> 0
    
    'Wait until DEC motor is stable

    Do
       eqres = EQ_GetMotorStatus(1)
       If (eqres = EQ_NOTINITIALIZED) Or (eqres = EQ_COMNOTOPEN) Or (eqres = EQ_COMTIMEOUT) Then
            GoTo Endhome
       End If
    Loop While (eqres And EQ_MOTORBUSY) <> 0
    
    'Read Motor Values
    
'    currentrapos = Delta_RA_Map(EQ_GetMotorValues(0))
'    currentdecpos = Delta_DEC_Map(EQ_GetMotorValues(1))

    gTrackingStatus = 0
    
    currentrapos = EQ_GetMotorValues(0)
    currentdecpos = EQ_GetMotorValues(1)
    
    gRAEncoderlastpos = currentrapos
    gDECEncoderlastpos = currentdecpos
    
    writelastpos   ' Save current position
    
    gRAEncoderUNPark = RAEncoder_Home_pos
    gDECEncoderUNPark = gDECEncoder_Home_pos
    
    writeUnpark
    
    i = Abs(currentrapos - RAEncoder_Home_pos)
    j = Abs(currentdecpos - gDECEncoder_Home_pos)
    
    ' Slew Both motors to the home position
    
    If i <> 0 Then
        If currentrapos < RAEncoder_Home_pos Then
            eqres = EQ_StartMoveMotor(0, 0, 0, i, GetSlowdown(i))
        Else
            eqres = EQ_StartMoveMotor(0, 0, 1, i, GetSlowdown(i))
        End If
    End If
    
    If j <> 0 Then
        If currentdecpos < gDECEncoder_Home_pos Then
            eqres = EQ_StartMoveMotor(1, 0, 0, j, GetSlowdown(j))
        Else
            eqres = EQ_StartMoveMotor(1, 0, 1, j, GetSlowdown(j))
        End If
    End If

    
    HC.Add_Message (HC.oLangDll.GetLangString(5035))
    HC.ParkTimer.Enabled = True
    ' No need to wait at this point - return control to main routine

Endhome:

End Sub

Public Sub SyncToRADEC(ByVal RightAscension As Double, ByVal Declination As Double, ByVal pLongitude As Double, ByVal pHemisphere As Long)

                                    
Dim targetRAEncoder As Double
Dim targetDECEncoder As Double
Dim currentRAEncoder As Double
Dim currentDECEncoder As Double

Dim tRA As Double
Dim tha As Double
Dim tPier As Double

Dim tmpcoord As Coordt


    If HC.ListSyncMode.ListIndex = 1 Then
        Call EQ_AlignViaSync(RightAscension, Declination, pLongitude, pHemisphere)
        Exit Sub
        
    End If

    gRASync01 = 0
    gDECSync01 = 0

    HC.EncoderTimer.Enabled = False
    
    If gThreeStarEnable = False Then
        currentRAEncoder = EQ_GetMotorValues(0) + gRA1Star
        currentDECEncoder = EQ_GetMotorValues(1) + gDEC1Star
    Else


        If HC.ListAlignMode.ListIndex = 2 Then
        
           tmpcoord = DeltaSync_Matrix_Map(EQ_GetMotorValues(0), EQ_GetMotorValues(1))
           currentRAEncoder = tmpcoord.x
           currentDECEncoder = tmpcoord.y
        
        Else
        
            If HC.ListAlignMode.ListIndex = 1 Then

                tmpcoord = Delta_Matrix_Reverse_Map(EQ_GetMotorValues(0), EQ_GetMotorValues(1))
                currentRAEncoder = tmpcoord.x
                currentDECEncoder = tmpcoord.y
            
            Else
                tmpcoord = Delta_Matrix_Reverse_Map(EQ_GetMotorValues(0), EQ_GetMotorValues(1))
                currentRAEncoder = tmpcoord.x
                currentDECEncoder = tmpcoord.y
        
                If tmpcoord.f = 0 Then
                    tmpcoord = DeltaSync_Matrix_Map(EQ_GetMotorValues(0), EQ_GetMotorValues(1))
                    currentRAEncoder = tmpcoord.x
                    currentDECEncoder = tmpcoord.y
                End If
        
            End If
        End If

    End If
    
    HC.EncoderTimer.Enabled = True
    
    tha = RangeHA(RightAscension - EQnow_lst(pLongitude * DEG_RAD))
  
    If tha < 0 Then
        If pHemisphere = 0 Then
            tPier = 1
        Else
            tPier = 0
        End If
        tRA = Range24(RightAscension - 12)
    Else
        If pHemisphere = 0 Then
            tPier = 0
        Else
            tPier = 1
        End If
        
        tRA = RightAscension
    End If

    'Compute for Sync RA/DEC Encoder Values

     targetRAEncoder = Get_RAEncoderfromRA(tRA, 0, pLongitude, gRAEncoder_Zero_pos, gTot_RA, pHemisphere)
     targetDECEncoder = Get_DECEncoderfromDEC(Declination, tPier, gDECEncoder_Zero_pos, gTot_DEC, pHemisphere)
          
 '    If gThreeStarEnable = True Then
 '
 '       tmpcoord = Delta_Matrix_Map(targetRAEncoder, targetDECEncoder)
 '       targetRAEncoder = tmpcoord.X
 '       targetDECEncoder = tmpcoord.Y'
 '
 '    End If
     
     If (Abs(targetRAEncoder - currentRAEncoder) > gEQ_MAXSYNC) Or (Abs(targetDECEncoder - currentDECEncoder) > gEQ_MAXSYNC) Then
     
        HC.Add_Message ("Abort: Sync value too big or Mount needs a pierflip")
        gEmulOneShot = True    ' Re Sync Display
        Exit Sub
     
     End If
     
          
     gRASync01 = targetRAEncoder - currentRAEncoder
     gDECSync01 = targetDECEncoder - currentDECEncoder
     
     
     WriteSyncMap
     
     HC.DxSalbl.Caption = Format$(Str(gRASync01), "000000000")
     
     HC.DxSblbl.Caption = Format$(Str(gDECSync01), "000000000")
     
     gEmulOneShot = True    ' Re Sync Display
     

End Sub

Public Sub ParktoUserDefine(ByVal withslew As Boolean)

    Dim currentdecpos As Double
    Dim currentrapos As Double
    
    Dim i As Long
    Dim j As Long


    eqres = EQ_MotorStop(0)          ' Stop RA Motor
    If eqres <> 0 Then
            GoTo Endparkuser
    End If
    eqres = EQ_MotorStop(1)          ' Stop DEC Motor
    If eqres <> 0 Then
            GoTo Endparkuser
    End If

    'Wait until RA motor is stable

    Do
       eqres = EQ_GetMotorStatus(0)
       If eqres = 1 Then
            GoTo Endparkuser
       End If
    Loop While (eqres And EQ_MOTORBUSY) <> 0
    
    'Wait until DEC motor is stable

    Do
       eqres = EQ_GetMotorStatus(1)
       If eqres = 1 Then
            GoTo Endparkuser
       End If
    Loop While (eqres And EQ_MOTORBUSY) <> 0
    
    'Read Motor Values

    
'    currentrapos = Delta_RA_Map(EQ_GetMotorValues(0))
'    currentdecpos = Delta_DEC_Map(EQ_GetMotorValues(1))

    gTrackingStatus = 0
    
    currentrapos = EQ_GetMotorValues(0)
    currentdecpos = EQ_GetMotorValues(1)
    
    
    gRAEncoderlastpos = currentrapos
    gDECEncoderlastpos = currentdecpos
    
    writelastpos   ' Save current position
        
    readpark       ' Read Userdefined Park data
 
    gRAEncoderUNPark = gRAEncoderPark
    gDECEncoderUNPark = gDECEncoderPark
    
    writeUnpark    ' Save Unpark Data
    
    
    If withslew Then
    
        i = Abs(currentrapos - gRAEncoderPark)
        j = Abs(currentdecpos - gDECEncoderPark)
    

        ' Slew Both motors to the user-defined park position
    
    
        If i <> 0 Then
            If currentrapos < gRAEncoderPark Then
                eqres = EQ_StartMoveMotor(0, 0, 0, i, GetSlowdown(i))
            Else
                eqres = EQ_StartMoveMotor(0, 0, 1, i, GetSlowdown(i))
            End If
        End If
    
        If j <> 0 Then
            If currentdecpos < gDECEncoderPark Then
                eqres = EQ_StartMoveMotor(1, 0, 0, j, GetSlowdown(j))
            Else
                eqres = EQ_StartMoveMotor(1, 0, 1, j, GetSlowdown(j))
            End If
        End If
        
    HC.ParkTimer.Enabled = True
    End If

Endparkuser:

End Sub
Public Sub DefinePark(ByVal StopMotors As Boolean)

    If StopMotors Then
        eqres = EQ_MotorStop(0)          ' Stop RA Motor
        If eqres <> 0 Then
            GoTo ENDDefinePark
        End If
        eqres = EQ_MotorStop(1)          ' Stop DEC Motor
        If eqres <> 0 Then
            GoTo ENDDefinePark
        End If

        'Wait until RA motor is stable

        Do
            eqres = EQ_GetMotorStatus(0)
            If eqres = 1 Then
                GoTo ENDDefinePark
             End If
        Loop While (eqres And EQ_MOTORBUSY) <> 0
    
        'Wait until DEC motor is stable

        Do
            eqres = EQ_GetMotorStatus(1)
            If eqres = 1 Then
                GoTo ENDDefinePark
            End If
        Loop While (eqres And EQ_MOTORBUSY) <> 0
     End If
    
    'Read Motor Values
    
 '   gRAEncoderPark = Delta_RA_Map(EQ_GetMotorValues(0))
 '   gDECEncoderPark = Delta_DEC_Map(EQ_GetMotorValues(1))

    gRAEncoderPark = EQ_GetMotorValues(0)
    gDECEncoderPark = EQ_GetMotorValues(1)


    writepark

ENDDefinePark:

End Sub
Public Sub Unparkscope()

    If gEQparkstatus = 1 Then

        readUnpark
    
        'Just make sure motors are not moving
    
        eqres = EQ_MotorStop(0)
        eqres = EQ_MotorStop(1)
    
        ' Restore Encoder values
    
'        eqres = EQ_SetMotorValues(0, Delta_RA_Map_encoder(gRAEncoderUNPark))
'        eqres = EQ_SetMotorValues(1, Delta_DEC_Map_encoder(gDECEncoderUNPark))
        
        eqres = EQ_SetMotorValues(0, gRAEncoderUNPark)
        eqres = EQ_SetMotorValues(1, gDECEncoderUNPark)
        
        
        HC.Add_Message (HC.oLangDll.GetLangString(5036))
        
        Call readRALimit

    Else
    
        HC.Add_Message (HC.oLangDll.GetLangString(5037))
    
    End If


End Sub

Public Sub UnparkscopeToLastPos()

    Dim i As Long
    Dim j As Long

    If gEQparkstatus = 1 Then

        'Unpark Scope first

        readUnpark
    
        'Just make sure motors are not moving
    
        eqres = EQ_MotorStop(0)
        eqres = EQ_MotorStop(1)
    
        ' Restore encoder values
    
 '       eqres = EQ_SetMotorValues(0, Delta_RA_Map_encoder(gRAEncoderUNPark))
 '       eqres = EQ_SetMotorValues(1, Delta_DEC_Map_encoder(gDECEncoderUNPark))

        eqres = EQ_SetMotorValues(0, gRAEncoderUNPark)
        eqres = EQ_SetMotorValues(1, gDECEncoderUNPark)


        'Then Slew Scope to last position prior to park command
    
    
    
        readlastpos
    
        i = Abs(gRAEncoderUNPark - gRAEncoderlastpos)
        j = Abs(gDECEncoderUNPark - gDECEncoderlastpos)
    
    
        If i <> 0 Then
            If gRAEncoderUNPark < gRAEncoderlastpos Then
                eqres = EQ_StartMoveMotor(0, 0, 0, i, GetSlowdown(i))
            Else
                eqres = EQ_StartMoveMotor(0, 0, 1, i, GetSlowdown(i))
            End If
        End If
    
        If j <> 0 Then
            If gDECEncoderUNPark < gDECEncoderlastpos Then
                eqres = EQ_StartMoveMotor(1, 0, 0, j, GetSlowdown(j))
            Else
                eqres = EQ_StartMoveMotor(1, 0, 1, j, GetSlowdown(j))
            End If
        End If
        
        HC.Add_Message (HC.oLangDll.GetLangString(5038))
        
        Call readRALimit
 
    Else
    
          HC.Add_Message (HC.oLangDll.GetLangString(5037))
    
    End If
 
End Sub

Public Sub readUnpark()

     Dim tmptxt As String

     tmptxt = HC.oPersist.ReadIniValue("UNPARK_RA")
     If tmptxt <> "" Then
        gRAEncoderUNPark = val(tmptxt)
     Else
        gRAEncoderUNPark = RAEncoder_Home_pos
     End If
     
     tmptxt = HC.oPersist.ReadIniValue("UNPARK_DEC")
     If tmptxt <> "" Then
        gDECEncoderUNPark = val(tmptxt)
     Else
        gDECEncoderUNPark = gDECEncoder_Home_pos
     End If
 
End Sub
Public Sub readpark()

     Dim tmptxt As String

     tmptxt = HC.oPersist.ReadIniValue("PARK_RA")
     If tmptxt <> "" Then
        gRAEncoderPark = val(tmptxt)
     Else
        gRAEncoderPark = RAEncoder_Home_pos
     End If
     
     tmptxt = HC.oPersist.ReadIniValue("PARK_DEC")
     If tmptxt <> "" Then
        gDECEncoderPark = val(tmptxt)
     Else
        gDECEncoderPark = gDECEncoder_Home_pos
     End If
 
End Sub
Public Sub readlastpos()

     Dim tmptxt As String

     tmptxt = HC.oPersist.ReadIniValue("LASTPOS_RA")
     If tmptxt <> "" Then
        gRAEncoderlastpos = val(tmptxt)
     Else
        gRAEncoderlastpos = RAEncoder_Home_pos
     End If
     
     tmptxt = HC.oPersist.ReadIniValue("LASTPOS_DEC")
     If tmptxt <> "" Then
        gDECEncoderlastpos = val(tmptxt)
     Else
        gDECEncoderlastpos = gDECEncoder_Home_pos
     End If
 
End Sub

Public Function readparkStatus() As Long

     Dim tmptxt As String
     tmptxt = HC.oPersist.ReadIniValue("EQPARKSTATUS")
     If tmptxt = "parked" Then
        readparkStatus = 1
     Else
        readparkStatus = 0
     End If

End Function
Public Sub readParkModes()
    Dim tmptxt As String
 
     tmptxt = HC.oPersist.ReadIniValue("DEFAULT_PARK_MODE")
     If tmptxt <> "" Then
        HC.ComboPark.ListIndex = val(tmptxt)
     Else
        HC.ComboPark.ListIndex = 0
     End If
     
     tmptxt = HC.oPersist.ReadIniValue("DEFAULT_UNPARK_MODE")
     If tmptxt <> "" Then
        HC.ComboUnPark.ListIndex = val(tmptxt)
     Else
        HC.ComboUnPark.ListIndex = 0
     End If
     
     Call SetParkCaption

End Sub

Public Sub writeParkMode_park()
     HC.oPersist.WriteIniValue "DEFAULT_PARK_MODE", CStr(HC.ComboPark.ListIndex)
End Sub
Public Sub writeParkMode_unpark()
     HC.oPersist.WriteIniValue "DEFAULT_UNPARK_MODE", CStr(HC.ComboUnPark.ListIndex)
End Sub

Public Sub writeParkStatus(ByVal pval As Long)

    If pval = 0 Then
        HC.oPersist.WriteIniValue "EQPARKSTATUS", CStr("unparked")
    Else
        HC.oPersist.WriteIniValue "EQPARKSTATUS", CStr("parked")
    End If
    
End Sub


Public Sub writeUnpark()

    HC.oPersist.WriteIniValue "UNPARK_RA", CStr(gRAEncoderUNPark)
    HC.oPersist.WriteIniValue "UNPARK_DEC", CStr(gDECEncoderUNPark)

End Sub

Public Sub writepark()

    HC.oPersist.WriteIniValue "PARK_RA", CStr(gRAEncoderPark)
    HC.oPersist.WriteIniValue "PARK_DEC", CStr(gDECEncoderPark)

End Sub

Public Sub writelastpos()

    HC.oPersist.WriteIniValue "LASTPOS_RA", CStr(gRAEncoderlastpos)
    HC.oPersist.WriteIniValue "LASTPOS_DEC", CStr(gDECEncoderlastpos)

End Sub
Public Sub WriteSyncMap()

    HC.oPersist.WriteIniValue "RSYNC01", CStr(gRASync01)
    HC.oPersist.WriteIniValue "DSYNC01", CStr(gDECSync01)

End Sub

Public Sub WriteAlignMap()

    HC.oPersist.WriteIniValue "RALIGN01", CStr(gRA1Star)
    HC.oPersist.WriteIniValue "DALIGN01", CStr(gDEC1Star)

End Sub


'Public Sub OneStarAlign(ByVal vRA As Double, ByVal vDEC As Double)

Public Sub resetsync()

    gRASync01 = 0
    gDECSync01 = 0
    
    WriteSyncMap
    
    HC.DxSalbl.Caption = Format$(Str(gRASync01), "000000000")
    HC.DxSblbl.Caption = Format$(Str(gDECSync01), "000000000")
    
End Sub

Public Sub writeratebarstateHC()

    HC.oPersist.WriteIniValue "BAR01_1", CStr(HC.VScroll1.Value)
    HC.oPersist.WriteIniValue "BAR01_2", CStr(HC.VScroll2.Value)
    HC.oPersist.WriteIniValue "BAR01_3", CStr(HC.VScroll3.Value)
    HC.oPersist.WriteIniValue "BAR01_4", CStr(HC.VScroll4.Value)
    HC.oPersist.WriteIniValue "BAR01_5", CStr(HC.VScroll5.Value)
    HC.oPersist.WriteIniValue "BAR01_6", CStr(HC.VScroll6.Value)

End Sub

Public Sub readratebarstateHC()

     Dim tmptxt As String

     tmptxt = HC.oPersist.ReadIniValue("BAR01_1")
     If tmptxt <> "" Then
        HC.VScroll1.Value = val(tmptxt)
     End If
     
     tmptxt = HC.oPersist.ReadIniValue("BAR01_2")
     If tmptxt <> "" Then
        HC.VScroll2.Value = val(tmptxt)
     End If
 
     tmptxt = HC.oPersist.ReadIniValue("BAR01_3")
     If tmptxt <> "" Then
        HC.VScroll3.Value = val(tmptxt)
     End If
     
     tmptxt = HC.oPersist.ReadIniValue("BAR01_4")
     If tmptxt <> "" Then
        HC.VScroll4.Value = val(tmptxt)
     End If

     tmptxt = HC.oPersist.ReadIniValue("BAR01_5")
     If tmptxt <> "" Then
        HC.VScroll5.Value = val(tmptxt)
     End If
     
     tmptxt = HC.oPersist.ReadIniValue("BAR01_6")
     If tmptxt <> "" Then
        HC.VScroll6.Value = val(tmptxt)
     End If
End Sub

Public Sub writeratebarstateAlign()

    HC.oPersist.WriteIniValue "BAR02_1", CStr(Align.HScroll1.Value)
    HC.oPersist.WriteIniValue "BAR02_2", CStr(Align.HScroll2.Value)


End Sub

Public Sub readratebarstateAlign()

     Dim tmptxt As String

     tmptxt = HC.oPersist.ReadIniValue("BAR02_1")
     If tmptxt <> "" Then
        Align.HScroll1.Value = val(tmptxt)
     End If
     
     tmptxt = HC.oPersist.ReadIniValue("BAR02_2")
     If tmptxt <> "" Then
        Align.HScroll2.Value = val(tmptxt)
     End If
 
  
End Sub

Public Sub writeratebarstatePad()

    HC.oPersist.WriteIniValue "BAR03_1", CStr(Slewpad.VScroll1.Value)
    HC.oPersist.WriteIniValue "BAR03_2", CStr(Slewpad.VScroll2.Value)


End Sub

Public Sub writeOnTop()

    HC.oPersist.WriteIniValue "ON_TOP1", CStr(HC.HCOnTop.Value)

End Sub

Public Sub readOnTop()

     Dim tmptxt As String

     tmptxt = HC.oPersist.ReadIniValue("ON_TOP1")
     If tmptxt <> "" Then
        HC.HCOnTop.Value = val(tmptxt)
     End If

End Sub

Public Sub writeAlignCheck1()
    If HC.ListAlignMode.ListIndex = 1 Then
        HC.oPersist.WriteIniValue "SYNCNSTAR", "1"
    Else
        HC.oPersist.WriteIniValue "SYNCNSTAR", "0"
    End If

End Sub

Public Sub writeAlignCheck2()

    If HC.ListSyncMode.ListIndex = 1 Then
        HC.oPersist.WriteIniValue "APPENDSYNCNSTAR", "1"
    Else
        HC.oPersist.WriteIniValue "APPENDSYNCNSTAR", "0"
    End If
        

End Sub

Public Sub readAlignCheck()

     Dim tmptxt As String

     tmptxt = HC.oPersist.ReadIniValue("SYNCNSTAR")
     If tmptxt <> "" Then
        HC.ListAlignMode.ListIndex = val(tmptxt)
     Else
        HC.ListAlignMode.ListIndex = 0
     End If

     tmptxt = HC.oPersist.ReadIniValue("APPENDSYNCNSTAR")
     If tmptxt <> "" Then
        HC.ListSyncMode.ListIndex = val(tmptxt)
     Else
        HC.ListSyncMode.ListIndex = 0
     End If
     
End Sub

Public Sub writeColorDat(a1 As Long, a2 As Long, a3 As Long, b1 As Long, b2 As Long, b3 As Long, f1 As Long)

    HC.oPersist.WriteIniValue "FOR_R", CStr(a1)
    HC.oPersist.WriteIniValue "FOR_G", CStr(a2)
    HC.oPersist.WriteIniValue "FOR_B", CStr(a3)
    
    HC.oPersist.WriteIniValue "BAK_R", CStr(b1)
    HC.oPersist.WriteIniValue "BAK_G", CStr(b2)
    HC.oPersist.WriteIniValue "BAK_B", CStr(b3)
    
    HC.oPersist.WriteIniValue "FONT_S", CStr(f1)

End Sub


Public Sub readColorDat()

     Dim i As Long
     Dim j As Long
     Dim k As Long
     
     Dim tmptxt As String

     tmptxt = HC.oPersist.ReadIniValue("FOR_R")
     If tmptxt <> "" Then
        i = val(tmptxt)
     Else
        i = &HFF
     End If

     tmptxt = HC.oPersist.ReadIniValue("FOR_G")
     If tmptxt <> "" Then
        j = val(tmptxt)
     Else
        j = &H80
     End If

     tmptxt = HC.oPersist.ReadIniValue("FOR_B")
     If tmptxt <> "" Then
        k = val(tmptxt)
     Else
        k = &H0
     End If

    i = i And &HFF
    j = (j * 256) And &HFF00
    k = (k * 65536) And &HFF0000
    
    HC.HCMessage.ForeColor = i + j + k
    HC.HCTextAlign.ForeColor = i + j + k
    
     tmptxt = HC.oPersist.ReadIniValue("BAK_R")
     If tmptxt <> "" Then
        i = val(tmptxt)
     Else
        i = &H80
     End If

     tmptxt = HC.oPersist.ReadIniValue("BAK_G")
     If tmptxt <> "" Then
        j = val(tmptxt)
     Else
        j = &H0
     End If

     tmptxt = HC.oPersist.ReadIniValue("BAK_B")
     If tmptxt <> "" Then
        k = val(tmptxt)
     Else
        k = &H0
     End If

    i = i And &HFF
    j = (j * 256) And &HFF00
    k = (k * 65536) And &HFF0000
    
    HC.HCMessage.BackColor = i + j + k
    HC.HCTextAlign.BackColor = i + j + k
    
     tmptxt = HC.oPersist.ReadIniValue("FONT_S")
     If tmptxt <> "" Then
        i = val(tmptxt)
     Else
        i = 7
     End If
     
    HC.HCMessage.FontSize = i
    HC.HCTextAlign.FontSize = i
     
 
End Sub


Public Sub readratebarstatePad()

     Dim tmptxt As String

     tmptxt = HC.oPersist.ReadIniValue("BAR03_1")
     If tmptxt <> "" Then
        Slewpad.VScroll1.Value = val(tmptxt)
     End If
     
     tmptxt = HC.oPersist.ReadIniValue("BAR03_2")
     If tmptxt <> "" Then
        Slewpad.VScroll2.Value = val(tmptxt)
     End If
   
End Sub

Public Sub readportrate()

     Dim raval As String
     Dim decval As String

     raval = HC.oPersist.ReadIniValue("AUTOGUIDER_RA")
   
     Select Case raval
                Case "x1.00":
                    eqres = EQ_SetAutoguiderPortRate(0, 3)
                    HC.RAGuideRateList.ListIndex = 3
                Case "x0.75":
                    eqres = EQ_SetAutoguiderPortRate(0, 2)
                    HC.RAGuideRateList.ListIndex = 2
                Case "x0.50":
                    eqres = EQ_SetAutoguiderPortRate(0, 1)
                    HC.RAGuideRateList.ListIndex = 1

                Case Else
                    eqres = EQ_SetAutoguiderPortRate(0, 0)
                    HC.RAGuideRateList.ListIndex = 0
    
    End Select
    
    
    decval = HC.oPersist.ReadIniValue("AUTOGUIDER_DEC")
    
    Select Case decval
                Case "x1.00":
                    eqres = EQ_SetAutoguiderPortRate(1, 3)
                     HC.DECGuideRateList.ListIndex = 3
                    
                Case "x0.75":
                    eqres = EQ_SetAutoguiderPortRate(1, 2)
                    HC.DECGuideRateList.ListIndex = 2
                Case "x0.50":
                    eqres = EQ_SetAutoguiderPortRate(1, 1)
                    HC.DECGuideRateList.ListIndex = 1
                Case Else
                    eqres = EQ_SetAutoguiderPortRate(1, 0)
                    HC.DECGuideRateList.ListIndex = 0
    End Select
   
   
End Sub


Public Sub writeportrateRa()

    HC.oPersist.WriteIniValue "AUTOGUIDER_RA", HC.RAGuideRateList.Text

End Sub
Public Sub writeportrateDec()

    HC.oPersist.WriteIniValue "AUTOGUIDER_DEC", HC.DECGuideRateList.Text

End Sub

Public Sub writePulseguidepwidth()
    HC.oPersist.WriteIniValue "PULSEGUIDE_TIMER_INTERVAL", CStr(HC.PltimerHscroll.Value)
End Sub

Public Sub readPulseguidepwidth()


     Dim tmptxt As String

     tmptxt = HC.oPersist.ReadIniValue("PULSEGUIDE_TIMER_INTERVAL")
 
     If tmptxt = "" Then
        HC.PltimerHscroll.Value = 50
        HC.Label40.Caption = " 50"
        HC.Pulseguide_Timer.Interval = 50
        gpl_interval = 50
     Else
        HC.PltimerHscroll.Value = val(tmptxt)
        HC.Label40.Caption = tmptxt
        HC.Pulseguide_Timer.Interval = val(tmptxt)
        gpl_interval = val(tmptxt)
     End If
     
End Sub
Public Sub writeRASyncCheckVal()
    HC.oPersist.WriteIniValue "RA_AUTOSYNC_VAL", CStr(HC.CheckRASync.Value)
End Sub
Public Sub readRASyncCheckVal()


     Dim tmptxt As String
     
     tmptxt = HC.oPersist.ReadIniValue("RA_AUTOSYNC_VAL")
 
     If tmptxt = "" Then
        HC.CheckRASync.Value = 0
     Else
        HC.CheckRASync.Value = val(tmptxt)
     End If
     
End Sub


Public Sub writeDriftVal()
    HC.oPersist.WriteIniValue "RA_DRIFT_VAL", CStr(HC.DriftScroll.Value)
End Sub


Public Sub readDriftVal()


     Dim tmptxt As String

     tmptxt = HC.oPersist.ReadIniValue("RA_DRIFT_VAL")
 
     If tmptxt = "" Then
        HC.DriftScroll.Value = 0
        HC.Driftlbl.Caption = " 0"
        eqres = EQ_SetOffset(0, 0)
     Else
        HC.DriftScroll.Value = val(tmptxt)
        HC.Driftlbl.Caption = tmptxt
        eqres = EQ_SetOffset(0, val(tmptxt) * -1)
     End If
     
    
End Sub

Public Sub writeRAlimit()

    HC.oPersist.WriteIniValue "RA_LIMIT_EAST", CStr(gRA_Limit_East)
    HC.oPersist.WriteIniValue "RA_LIMIT_WEST", CStr(gRA_Limit_West)

End Sub

Public Sub readRALimit()

     Dim tmptxt As String

     tmptxt = HC.oPersist.ReadIniValue("RA_LIMIT_EAST")
 
     If tmptxt <> "" Then
        gRA_Limit_East = val(tmptxt)
     Else
        gRA_Limit_East = &H5D5500
     End If

     
     tmptxt = HC.oPersist.ReadIniValue("RA_LIMIT_WEST")
     If tmptxt <> "" Then
        gRA_Limit_West = val(tmptxt)
     Else
        gRA_Limit_West = &HA2AB00
     End If
     
    If gHemisphere = 0 Then
    
        HC.Label35.Caption = printhex(gRA_Limit_West)
        HC.Label36.Caption = printhex(gRA_Limit_East)
    
    Else
    
        HC.Label36.Caption = printhex(gRA_Limit_West)
        HC.Label35.Caption = printhex(gRA_Limit_East)
    
    End If

   
End Sub


Public Sub ReadSiteValues()
    
     Dim tmptxt As String
  
     HC.cbNS.ListIndex = 0
     HC.cbEW.ListIndex = 0
     HC.cbhem.ListIndex = 0
   
     tmptxt = HC.oPersist.ReadIniValue("LongitudeDeg")
     If tmptxt <> "" Then HC.txtLongDeg.Text = tmptxt
     
     tmptxt = HC.oPersist.ReadIniValue("LongitudeMin")
     If tmptxt <> "" Then HC.txtLongMin.Text = tmptxt
     
     tmptxt = HC.oPersist.ReadIniValue("LongitudeEW")
     If tmptxt <> "" Then HC.cbEW.ListIndex = val(tmptxt)
     
     tmptxt = HC.oPersist.ReadIniValue("LatitudeDeg")
     If tmptxt <> "" Then HC.txtLatDeg.Text = tmptxt
   
     tmptxt = HC.oPersist.ReadIniValue("LatitudeMin")
     If tmptxt <> "" Then HC.txtLatMin.Text = tmptxt
     
     tmptxt = HC.oPersist.ReadIniValue("LatitudeNS")
     If tmptxt <> "" Then HC.cbNS.ListIndex = val(tmptxt)
     
     tmptxt = HC.oPersist.ReadIniValue("Elevation")
     If tmptxt <> "" Then HC.txtElevation = tmptxt
     
     tmptxt = HC.oPersist.ReadIniValue("TimeDelta")
     If tmptxt <> "" Then gEQTimeDelta = val(EQFixNum(tmptxt))
     
      tmptxt = HC.oPersist.ReadIniValue("HemisphereNS")
     If tmptxt <> "" Then HC.cbhem.ListIndex = val(tmptxt)
     
     gLongitude = CDbl(EQFixNum(HC.txtLongDeg)) + (CDbl(EQFixNum(HC.txtLongMin)) / 60#)
     If HC.cbEW.Text = HC.oLangDll.GetLangString(115) Then gLongitude = -gLongitude  ' W is neg
    
     gLatitude = CDbl(EQFixNum(HC.txtLatDeg)) + (CDbl(EQFixNum(HC.txtLatMin)) / 60#)
     If HC.cbNS.Text = HC.oLangDll.GetLangString(116) Then gLatitude = -gLatitude
     gElevation = CDbl(EQFixNum(HC.txtElevation))
     
     If HC.cbhem.Text = HC.oLangDll.GetLangString(1110) Then
        gHemisphere = 0
     Else
        gHemisphere = 1
     End If
     
End Sub

Public Sub WriteSiteValues()

        HC.oPersist.WriteIniValue "LatitudeDeg", CStr(HC.txtLatDeg.Text)
        HC.oPersist.WriteIniValue "LatitudeMin", CStr(HC.txtLatMin.Text)
        HC.oPersist.WriteIniValue "LatitudeNS", CStr(HC.cbNS.ListIndex)
        HC.oPersist.WriteIniValue "LongitudeDeg", CStr(HC.txtLongDeg.Text)
        HC.oPersist.WriteIniValue "LongitudeMin", CStr(HC.txtLongMin.Text)
        HC.oPersist.WriteIniValue "LongitudeEW", CStr(HC.cbEW.ListIndex)
        HC.oPersist.WriteIniValue "HemisphereNS", CStr(HC.cbhem.ListIndex)
        HC.oPersist.WriteIniValue "Elevation", CStr(HC.txtElevation.Text)
        HC.oPersist.WriteIniValue "TimeDelta", CStr(EQFixNum(Str(gEQTimeDelta)))

End Sub

' Start RA motor based on an input rate of arcsec per Second

Public Sub StartRA_by_Rate(ByVal RA_RATE As Double)

Dim i As Double
Dim j As Double
Dim k As Double
Dim m As Double

    k = 0
    m = 1
    
    If gMount_Ver > &H301 Then
        If RA_RATE > 1000 Then
            k = 1
            m = EQ_GP(0, 10003)
        End If
    Else
        If RA_RATE > 3000 Then
            k = 1
            m = EQ_GP(0, 10003)
        End If
    End If

    HC.Add_Message (HC.oLangDll.GetLangString(117) & " " & Str(m) & " , " & Str(RA_RATE) & " arcseconds")

    eqres = EQ_MotorStop(0)          ' Stop RA Motor
    If eqres <> EQ_OK Then
        GoTo RARateEndhome1
    End If
    
    Do
       eqres = EQ_GetMotorStatus(0)
       If (eqres = EQ_NOTINITIALIZED) Or (eqres = EQ_COMNOTOPEN) Or (eqres = EQ_COMTIMEOUT) Then
            GoTo RARateEndhome1
       End If
    Loop While (eqres And EQ_MOTORBUSY) <> 0
    

    If RA_RATE = 0 Then
        gSlewStatus = False
        gRAStatus_slew = False
        HC.GotoTimer.Enabled = False
        eqres = EQ_MotorStop(0)
        Exit Sub
    End If

    i = RA_RATE
    j = Abs(i)              'Get the absolute value for parameter passing
    
    
   
    If gMount_Ver = &H301 Then
      If (j > 1350) And (j <= 3000) Then
        If j < 2175 Then
            j = 1350
        Else
            j = 3001
            k = 1
            m = EQ_GP(0, 10003)
        End If
      End If
    End If
    
    gRAMoveAxis_Rate = k    'Save Speed Settings
    
    j = Int((m * 9325.46154 / j) + 0.5) + 30000 'Compute for the rate
'    j = Int((m * 9325.77 / j) + 0.5) + 30000 'Compute for the rate parameter

    If i >= 0 Then
        eqres = EQ_SetCustomTrackRate(0, 1, j, k, gHemisphere, 0)
    Else
        eqres = EQ_SetCustomTrackRate(0, 1, j, k, gHemisphere, 1)
    End If

RARateEndhome1:

End Sub

' Change RA motor rate based on an input rate of arcsec per Second

Public Sub ChangeRA_by_Rate(ByVal RA_RATE As Double)

Dim i As Double
Dim j As Double
Dim k As Double
Dim m As Double

    k = 0
    m = 1
    
    If gMount_Ver > &H301 Then
        If RA_RATE > 1000 Then
            k = 1
            m = EQ_GP(0, 10003)
        End If
    Else
        If RA_RATE > 3000 Then
            k = 1
            m = EQ_GP(0, 10003)
        End If
    End If

    HC.Add_Message (HC.oLangDll.GetLangString(117) & " " & Str(m) & " , " & Str(RA_RATE) & " arcseconds")

    If RA_RATE = 0 Then
        gSlewStatus = False
        gRAStatus_slew = False
        HC.GotoTimer.Enabled = False
        eqres = EQ_MotorStop(0)
        
        Exit Sub
    End If

    i = RA_RATE
    j = Abs(i)              'Get the absolute value for parameter passing
    
    
    If gMount_Ver = &H301 Then
      If (j > 1350) And (j <= 3000) Then
        If j < 2175 Then
            j = 1350
        Else
            j = 3001
            k = 1
            m = EQ_GP(0, 10003)
        End If
      End If
    End If
    

    If k <> gRAMoveAxis_Rate Then
     
     eqres = EQ_MotorStop(0)          ' Stop RA Motor
     If eqres <> EQ_OK Then
        GoTo RARateEndhome2
     End If
    
     Do
       eqres = EQ_GetMotorStatus(0)
       If (eqres = EQ_NOTINITIALIZED) Or (eqres = EQ_COMNOTOPEN) Or (eqres = EQ_COMTIMEOUT) Then
            GoTo RARateEndhome2
       End If
     Loop While (eqres And EQ_MOTORBUSY) <> 0
     
     gRAMoveAxis_Rate = k
    
     j = Int((m * 9325.46154 / j) + 0.5) + 30000 'Compute for the rate
'     j = Int((m * 9325.77 / j) + 0.5) + 30000 'Compute for the rate parameter

     If i >= 0 Then
        eqres = EQ_SetCustomTrackRate(0, 1, j, k, gHemisphere, 0)
     Else
        eqres = EQ_SetCustomTrackRate(0, 1, j, k, gHemisphere, 1)
     End If

    Else
    
     gRAMoveAxis_Rate = k
    
     j = Int((m * 9325.46154 / j) + 0.5) + 30000 'Compute for the rate
'     j = Int((m * 9325.77 / j) + 0.5) + 30000 'Compute for the rate parameter

     If i >= 0 Then
        eqres = EQ_SetCustomTrackRate(0, 0, j, k, gHemisphere, 0)
     Else
        eqres = EQ_SetCustomTrackRate(0, 0, j, k, gHemisphere, 1)
     End If
     
   End If
    
RARateEndhome2:
    
End Sub


' Start DEC motor based on an input rate of arcsec per Second

Public Sub StartDEC_by_Rate(ByVal DEC_RATE As Double)

Dim i As Double
Dim j As Double
Dim k As Double
Dim m As Double

    k = 0
    m = 1
    
    If gMount_Ver > &H301 Then
        If DEC_RATE > 1000 Then
            k = 1
            m = EQ_GP(1, 10003)
        End If
    Else
        If DEC_RATE > 3000 Then
            k = 1
            m = EQ_GP(1, 10003)
        End If
    End If
    
    
    HC.Add_Message (HC.oLangDll.GetLangString(118) & " " & Str(m) & " , " & Str(DEC_RATE) & " arcseconds")
    
    eqres = EQ_MotorStop(1)          ' Stop RA Motor
    If eqres <> EQ_OK Then
        GoTo DECRateEndhome1
    End If
    
    Do
       eqres = EQ_GetMotorStatus(1)
       If (eqres = EQ_NOTINITIALIZED) Or (eqres = EQ_COMNOTOPEN) Or (eqres = EQ_COMTIMEOUT) Then
            GoTo DECRateEndhome1
       End If
    Loop While (eqres And EQ_MOTORBUSY) <> 0

    If DEC_RATE = 0 Then
        gSlewStatus = False
        gRAStatus_slew = False
        HC.GotoTimer.Enabled = False
        eqres = EQ_MotorStop(1)
        Exit Sub
    End If
    
    i = DEC_RATE
    j = Abs(i)              'Get the absolute value for parameter passing
    
  
    If gMount_Ver = &H301 Then
      If (j > 1350) And (j <= 3000) Then
        If j < 2175 Then
            j = 1350
        Else
            j = 3001
            k = 1
            m = EQ_GP(1, 10003)
        End If
      End If
    End If
    
    
    gDECMoveAxis_Rate = k    'Save Speed Settings
    
'    j = Int((m * 9325.77 / j) + 0.5) + 30000 'Compute for the rate parameter
    j = Int((m * 9325.46154 / j) + 0.5) + 30000 'Compute for the rate

    If i >= 0 Then
        eqres = EQ_SetCustomTrackRate(1, 1, j, k, gHemisphere, 0)
    Else
        eqres = EQ_SetCustomTrackRate(1, 1, j, k, gHemisphere, 1)
    End If
    
DECRateEndhome1:

End Sub



' Change DEC motor rate based on an input rate of arcsec per Second

Public Sub ChangeDEC_by_Rate(ByVal DEC_RATE As Double)

Dim i As Double
Dim j As Double
Dim k As Double
Dim m As Double

    k = 0
    m = 1

    If gMount_Ver > &H301 Then
        If DEC_RATE > 1000 Then
            k = 1
            m = EQ_GP(1, 10003)
        End If
    Else
        If DEC_RATE > 3000 Then
            k = 1
            m = EQ_GP(1, 10003)
        End If
    End If

    HC.Add_Message (HC.oLangDll.GetLangString(118) & " " & Str(m) & " , " & Str(DEC_RATE) & " arcseconds")

    If DEC_RATE = 0 Then
        gSlewStatus = False
        gRAStatus_slew = False
        HC.GotoTimer.Enabled = False
        eqres = EQ_MotorStop(1)
        Exit Sub
    End If

    i = DEC_RATE
    j = Abs(i)              'Get the absolute value for parameter passing


    If gMount_Ver <= &H301 Then
      If (j > 1350) And (j <= 3000) Then
        If j < 2175 Then
            j = 1350
        Else
            j = 3001
            k = 1
            m = EQ_GP(1, 10003)
        End If
      End If
    End If


    If k <> gDECMoveAxis_Rate Then
     
     eqres = EQ_MotorStop(1)          ' Stop RA Motor
     If eqres <> EQ_OK Then
        GoTo DECRateEndhome2
     End If
    
     Do
       eqres = EQ_GetMotorStatus(1)
       If (eqres = EQ_NOTINITIALIZED) Or (eqres = EQ_COMNOTOPEN) Or (eqres = EQ_COMTIMEOUT) Then
            GoTo DECRateEndhome2
       End If
     Loop While (eqres And EQ_MOTORBUSY) <> 0
     
      gDECMoveAxis_Rate = k

'      j = Int((m * 9325.77 / j) + 0.5) + 30000 'Compute for the rate parameter
      j = Int((m * 9325.46154 / j) + 0.5) + 30000 'Compute for the rate

      If i >= 0 Then
        eqres = EQ_SetCustomTrackRate(1, 1, j, k, gHemisphere, 0)
      Else
        eqres = EQ_SetCustomTrackRate(1, 1, j, k, gHemisphere, 1)
      End If

    Else
    
      gDECMoveAxis_Rate = k

'      j = Int((m * 9325.77 / j) + 0.5) + 30000 'Compute for the rate parameter
      j = Int((m * 9325.46154 / j) + 0.5) + 30000 'Compute for the rate

      If i >= 0 Then
        eqres = EQ_SetCustomTrackRate(1, 0, j, k, gHemisphere, 0)
      Else
        eqres = EQ_SetCustomTrackRate(1, 0, j, k, gHemisphere, 1)
      End If
    
   End If
   
DECRateEndhome2:

End Sub


Public Sub EQMoveAxis(axis As Double, rate As Double)

Dim j As Double

    If rate <> 0 Then HC.TrackingFrame.Caption = HC.oLangDll.GetLangString(121) & " " & HC.oLangDll.GetLangString(189)

    j = rate * 3600 ' Convert to Arcesconds

    If axis = 0 Then
    
        If rate = 0 And (gDeclinationRate = 0) Then HC.TrackingFrame.Caption = HC.oLangDll.GetLangString(121) & " " & HC.oLangDll.GetLangString(178)
    
        If (gRightAscensionRate * j) <= 0 Then
            Call StartRA_by_Rate(j)
        Else
            Call ChangeRA_by_Rate(j)
        End If
  
        gRightAscensionRate = j
        If rate <> 0 Then gTrackingStatus = 4
    
    End If
    
    If axis = 1 Then
    
        If rate = 0 And (gRightAscensionRate = 0) Then HC.TrackingFrame.Caption = HC.oLangDll.GetLangString(121) & " " & HC.oLangDll.GetLangString(178)
    
        j = j * -1

        If gHemisphere = 0 Then
            If (gDec_DegNoAdjust > 90) And (gDec_DegNoAdjust <= 270) Then j = j * -1
        Else
            If (gDec_DegNoAdjust <= 90) Or (gDec_DegNoAdjust > 270) Then j = j * -1
        End If

        If (gDeclinationRate * j) <= 0 Then
            Call StartDEC_by_Rate(j)
        Else
            Call ChangeDEC_by_Rate(j)
        End If
    
        gDeclinationRate = j
        If rate <> 0 Then gTrackingStatus = 4
    
    End If
    
    
End Sub
Public Sub EQPecMoveAxis(axis As Double, rate As Double)

Dim j As Double

    If rate <> 0 Then HC.TrackingFrame.Caption = HC.oLangDll.GetLangString(121) & " " & HC.oLangDll.GetLangString(188)

    j = rate * 3600 ' Convert to Arcesconds

    If axis = 0 Then
    
        If rate = 0 And (gDeclinationRate = 0) Then HC.TrackingFrame.Caption = HC.oLangDll.GetLangString(121) & " " & HC.oLangDll.GetLangString(178)
    
        If gEQRAPulseDuration = 0 Then
            If (gRightAscensionRate * j) <= 0 Then
                Call StartRA_by_Rate(j)
            Else
                Call ChangeRA_by_Rate(j)
            End If
        End If
        
        gRightAscensionRate = j
        gTrackingStatus = 1
        gRA_LastRate = j
     
    End If
    
    If axis = 1 Then
    
        If rate = 0 And (gRightAscensionRate = 0) Then HC.TrackingFrame.Caption = HC.oLangDll.GetLangString(121) & " " & HC.oLangDll.GetLangString(178)
    
        j = j * -1

        If gHemisphere = 0 Then
            If (gDec_DegNoAdjust > 90) And (gDec_DegNoAdjust <= 270) Then j = j * -1
        Else
            If (gDec_DegNoAdjust <= 90) Or (gDec_DegNoAdjust > 270) Then j = j * -1
        End If

        If (gDeclinationRate * j) <= 0 Then
            Call StartDEC_by_Rate(j)
        Else
            Call ChangeDEC_by_Rate(j)
        End If
    
        gDeclinationRate = j
        gTrackingStatus = 1
    
    End If
    
    
End Sub

Public Sub CustomMoveAxis(axis As Double, rate As Double)

Dim j As Double

    If rate <> 0 Then HC.TrackingFrame.Caption = HC.oLangDll.GetLangString(121) & " " & HC.oLangDll.GetLangString(189)

    j = rate

    If axis = 0 Then
    
        If rate = 0 And (gDeclinationRate = 0) Then HC.TrackingFrame.Caption = HC.oLangDll.GetLangString(121) & " " & HC.oLangDll.GetLangString(178)
    
 '       If (gRightAscensionRate * j) <= 0 Then
            Call StartRA_by_Rate(j)
 '       Else
 '          Call ChangeRA_by_Rate(j)
 '       End If
  
        gRightAscensionRate = j
        gTrackingStatus = 4
    
    End If
    
    If axis = 1 Then
    
        If rate = 0 And (gRightAscensionRate = 0) Then HC.TrackingFrame.Caption = HC.oLangDll.GetLangString(121) & " " & HC.oLangDll.GetLangString(178)
    

 '       If (gDeclinationRate * j) <= 0 Then
            Call StartDEC_by_Rate(j)
 '       Else
 '          Call ChangeDEC_by_Rate(j)
 '      End If
    
        gDeclinationRate = j
        gTrackingStatus = 4
    
    End If
    
    
End Sub

Public Sub Start_CustomTracking()

Dim i As Double
Dim j As Double

        i = val(HC.raCustom)
        j = val(HC.decCustom)
        
        If (Abs(i) > 999) Or (Abs(j) > 999) Then
            
            HC.Add_Message (HC.oLangDll.GetLangString(5039))
            Call emergency_stop
            Exit Sub
        
        End If
        
        HC.Add_Message (HC.oLangDll.GetLangString(5040) & Format$(Str(i), "000.00") & " DEC:" & Format$(Str(j), "000.00") & " deg/sec")

        Call CustomMoveAxis(0, i)
        Call CustomMoveAxis(1, j)
        
        
End Sub

Public Sub Restore_CustomTracking()


    If gTrackingStatus = 4 Then
        Call CustomMoveAxis(0, gRightAscensionRate)
        Call CustomMoveAxis(1, gDeclinationRate)
    End If
        
End Sub

Public Sub EQ_Beep()

    If HC.ChkBeep.Value = 1 Then
        BeepAPI 600, 100
    End If
    
End Sub
Public Sub EQ_ClickBeep()

    If HC.ChkBeep.Value = 1 Then
        BeepAPI 100, 1
    End If
    
End Sub

Public Sub writeBeep()
    HC.oPersist.WriteIniValue "BEEP", CStr(HC.ChkBeep.Value)
End Sub
Public Sub readBeep()
Dim tmptxt As String

    tmptxt = HC.oPersist.ReadIniValue("BEEP")
    If tmptxt <> "" Then
        HC.ChkBeep.Value = val(tmptxt)
    Else
        HC.ChkBeep.Value = 0
        Call writeBeep
    End If
    
End Sub
Public Sub writeCustomRa()
    HC.oPersist.WriteIniValue "CUSTOM_RA", HC.raCustom.Text
    HC.oPersist.WriteIniValue "CUSTOM_DEC", HC.decCustom.Text
End Sub
Public Sub readCustomRa()
Dim tmptxt As String

    tmptxt = HC.oPersist.ReadIniValue("CUSTOM_RA")
    If tmptxt <> "" Then
        HC.raCustom.Text = tmptxt
    Else
        HC.raCustom.Text = "15.041067"
        Call writeCustomRa
    End If
    
    tmptxt = HC.oPersist.ReadIniValue("CUSTOM_DEC")
    If tmptxt <> "" Then
        HC.decCustom.Text = tmptxt
    Else
        HC.decCustom.Text = "0"
        Call writeCustomRa
    End If
    
End Sub


Public Sub writeAxisRevRA()

    HC.oPersist.WriteIniValue "RA_REVERSE", CStr(HC.RA_inv.Value)

End Sub


Public Sub writeAxisRevDEC()

    HC.oPersist.WriteIniValue "DEC_REVERSE", CStr(HC.DEC_Inv.Value)

End Sub
Public Sub readSiderealRate()
Dim tmptxt As String
    tmptxt = HC.oPersist.ReadIniValue("SIDEREAL_RATE")
    If tmptxt <> "" Then
        gSiderealRate = val(tmptxt)
    Else
        gSiderealRate = 15.041067
        Call writeSiderealRate
    End If
End Sub
Public Sub writeSiderealRate()
    HC.oPersist.WriteIniValue "SIDEREAL_RATE", CStr(gSiderealRate)
End Sub


Public Sub readAxisRev()

     Dim tmptxt As String

     tmptxt = HC.oPersist.ReadIniValue("RA_REVERSE")
     If tmptxt <> "" Then
        HC.RA_inv.Value = val(tmptxt)
     End If
     
     tmptxt = HC.oPersist.ReadIniValue("DEC_REVERSE")
     If tmptxt <> "" Then
        HC.DEC_Inv.Value = val(tmptxt)
     End If

End Sub
Public Sub writePresetSlewRates()
Dim tmptxt As String
Dim key As String
Dim valstr As String
Dim Ini As String
Dim count As Integer

    ' set up a file path for the align.ini file
    Ini = HC.oPersist.GetIniPath & "\EQMOD.ini"

    key = "[slewrates]"

    Call HC.oPersist.WriteIniValueEx("COUNT", CStr(gPresetSlewRatesCount), key, Ini)
    
    For count = 1 To gPresetSlewRatesCount
        valstr = "RATE_" & CStr(count)
        Call HC.oPersist.WriteIniValueEx(valstr, CStr(gPresetSlewRates(count)), key, Ini)
    Next count

    For count = 1 To 4
        valstr = "RATEBTN_" & CStr(count)
        Call HC.oPersist.WriteIniValueEx(valstr, CStr(gRateButtons(count)), key, Ini)
    Next count

End Sub
Public Sub readPresetSlewRates()

Dim tmptxt As String
Dim key As String
Dim valstr As String
Dim Ini As String
Dim count As Integer
Dim DefaultRates(1 To 10) As Integer

    DefaultRates(1) = 1
    DefaultRates(2) = 8
    DefaultRates(3) = 64
    DefaultRates(4) = 800
    DefaultRates(5) = 0
    DefaultRates(6) = 0
    DefaultRates(7) = 0
    DefaultRates(8) = 0
    DefaultRates(9) = 0
    DefaultRates(10) = 0
    
    HC.PresetRateCombo.Clear
    
    ' set up a file path for the align.ini file
    Ini = HC.oPersist.GetIniPath & "\EQMOD.ini"

    key = "[slewrates]"

    ' read preset count
    tmptxt = HC.oPersist.ReadIniValueEx("COUNT", key, Ini)
    If tmptxt <> "" Then
        gPresetSlewRatesCount = val(tmptxt)
        If gPresetSlewRatesCount > 10 Then
            gPresetSlewRatesCount = 10
            Call HC.oPersist.WriteIniValueEx("COUNT", "10", key, Ini)
        End If
    Else
        gPresetSlewRatesCount = 4
        Call HC.oPersist.WriteIniValueEx("COUNT", "4", key, Ini)
    End If
    
    For count = 1 To gPresetSlewRatesCount
        valstr = "RATE_" & CStr(count)
        tmptxt = HC.oPersist.ReadIniValueEx(valstr, key, Ini)
        If tmptxt <> "" Then
            gPresetSlewRates(count) = val(tmptxt)
        Else
            gPresetSlewRates(count) = DefaultRates(count)
            Call HC.oPersist.WriteIniValueEx(valstr, CStr(gPresetSlewRates(count)), key, Ini)
        End If
        ' add preset to combo
        HC.PresetRateCombo.AddItem (CStr(count))
    Next count
    
    tmptxt = HC.oPersist.ReadIniValueEx("InitalPreset", key, Ini)
    If tmptxt <> "" Then
        gCurrentRatePreset = val(tmptxt)
        If gCurrentRatePreset > 10 Then
            gCurrentRatePreset = 1
            Call HC.oPersist.WriteIniValueEx("InitalPreset", "1", key, Ini)
        End If
    Else
        gCurrentRatePreset = 1
        Call HC.oPersist.WriteIniValueEx("InitalPreset", "1", key, Ini)
    End If

    HC.PresetRateCombo.ListIndex = gCurrentRatePreset - 1
    
    
    For count = 1 To 4
        valstr = "RATEBTN_" & CStr(count)
        tmptxt = HC.oPersist.ReadIniValueEx(valstr, key, Ini)
        If tmptxt <> "" Then
            gRateButtons(count) = val(tmptxt)
        Else
            gRateButtons(count) = count
            Call HC.oPersist.WriteIniValueEx(valstr, CStr(count), key, Ini)
        End If
    Next count
    
    
End Sub

Public Sub LoadSites()
Dim tmptxt As String
Dim key As String
Dim valstr As String
Dim Ini As String
Dim Index As Integer

    ' set up a file path for the align.ini file
    Ini = HC.oPersist.GetIniPath & "\EQMOD.ini"
        
    For Index = 1 To 10
        key = "[site" & CStr(Index) & "]"
        tmptxt = HC.oPersist.ReadIniValueEx("Name", key, Ini)
        If tmptxt <> "" Then
            HC.SitesCombo.AddItem (tmptxt)
        Else
            HC.SitesCombo.AddItem (HC.oLangDll.GetLangString(187) & CStr(Index))
        End If
    Next Index

End Sub

Public Sub LoadSite(Index As Integer)
Dim tmptxt As String
Dim key As String
Dim Ini As String
Dim count As Integer

    ' set up a file path for the align.ini file
    Ini = HC.oPersist.GetIniPath & "\EQMOD.ini"
        
    key = "[site" & CStr(Index + 1) & "]"
    
    tmptxt = HC.oPersist.ReadIniValueEx("LongitudeDeg", key, Ini)
    If tmptxt <> "" Then HC.txtLongDeg.Text = tmptxt
    
    tmptxt = HC.oPersist.ReadIniValueEx("LongitudeMin", key, Ini)
    If tmptxt <> "" Then HC.txtLongMin.Text = tmptxt
    
    tmptxt = HC.oPersist.ReadIniValueEx("LongitudeEW", key, Ini)
    If tmptxt <> "" Then HC.cbEW.ListIndex = val(tmptxt)
    
    tmptxt = HC.oPersist.ReadIniValueEx("LatitudeDeg", key, Ini)
    If tmptxt <> "" Then HC.txtLatDeg.Text = tmptxt
    
    tmptxt = HC.oPersist.ReadIniValueEx("LatitudeMin", key, Ini)
    If tmptxt <> "" Then HC.txtLatMin.Text = tmptxt
    
    tmptxt = HC.oPersist.ReadIniValueEx("LatitudeNS", key, Ini)
    If tmptxt <> "" Then HC.cbNS.ListIndex = val(tmptxt)
    
    tmptxt = HC.oPersist.ReadIniValueEx("Elevation", key, Ini)
    If tmptxt <> "" Then HC.txtElevation = tmptxt
    
    tmptxt = HC.oPersist.ReadIniValueEx("TimeDelta", key, Ini)
    If tmptxt <> "" Then gEQTimeDelta = val(EQFixNum(tmptxt))
    
    tmptxt = HC.oPersist.ReadIniValueEx("HemisphereNS", key, Ini)
    If tmptxt <> "" Then HC.cbhem.ListIndex = val(tmptxt)
  
End Sub

Public Sub SaveSite(Index As Integer)
    Dim key As String
    Dim Ini As String

    ' set up a file path for the align.ini file
    Ini = HC.oPersist.GetIniPath & "\EQMOD.ini"
        
    key = "[site" & CStr(Index + 1) & "]"
    
    Call HC.oPersist.WriteIniValueEx("Name", CStr(HC.SitesCombo.List(Index)), key, Ini)
    Call HC.oPersist.WriteIniValueEx("LatitudeDeg", CStr(HC.txtLatDeg.Text), key, Ini)
    Call HC.oPersist.WriteIniValueEx("LatitudeMin", CStr(HC.txtLatMin.Text), key, Ini)
    Call HC.oPersist.WriteIniValueEx("LatitudeNS", CStr(HC.cbNS.ListIndex), key, Ini)
    Call HC.oPersist.WriteIniValueEx("LongitudeDeg", CStr(HC.txtLongDeg.Text), key, Ini)
    Call HC.oPersist.WriteIniValueEx("LongitudeMin", CStr(HC.txtLongMin.Text), key, Ini)
    Call HC.oPersist.WriteIniValueEx("LongitudeEW", CStr(HC.cbEW.ListIndex), key, Ini)
    Call HC.oPersist.WriteIniValueEx("HemisphereNS", CStr(HC.cbhem.ListIndex), key, Ini)
    Call HC.oPersist.WriteIniValueEx("Elevation", CStr(HC.txtElevation.Text), key, Ini)
    Call HC.oPersist.WriteIniValueEx("TimeDelta", CStr(EQFixNum(Str(gEQTimeDelta))), key, Ini)

End Sub

Public Sub readWormSteps()

     Dim tmptxt As String

     tmptxt = HC.oPersist.ReadIniValue("RA_STEPS_PER_WORM")
     If tmptxt <> "" Then
        gRAWormSteps = val(tmptxt)
     Else
        gRAWormSteps = 50133
        HC.oPersist.WriteIniValue "RA_STEPS_PER_WORM", CStr(gRAWormSteps)
     End If
     
     tmptxt = HC.oPersist.ReadIniValue("DEC_STEPS_PER_WORM")
     If tmptxt <> "" Then
        gDECWormSteps = val(tmptxt)
     Else
        gDECWormSteps = 50133
        HC.oPersist.WriteIniValue "DEC_STEPS_PER_WORM", CStr(gDECWormSteps)
     End If

End Sub
Public Sub LoadLanguageDll()
     LanguageDll = HC.oPersist.ReadIniValue("LANG_DLL")
     If LanguageDll = "" Then
        ' no value exists - create a default from locale
        LanguageDll = HC.oLangDll.GetDefaultDllName
        ' create an ini file entry but don't assign a value
        ' this way the loacale is always used unless manually edited.
        Call HC.oPersist.WriteIniValue("LANG_DLL", "")
     End If
End Sub
Public Sub SetParkCaption()
    If gEQparkstatus Then
        ' parked - use unpark text
        HC.CommandPark.Caption = HC.ComboUnPark.Text
    Else
        ' unparked - use park text
        HC.CommandPark.Caption = HC.ComboPark.Text
    End If
End Sub


Public Function GetEmulRA() As Double

Dim emulinc As Double

                    ' Compute for elapsed Time
                    
    If gTrackingStatus = 1 Then

                    gCurrent_time = EQnow_lst_norange()
                    If gLast_time = 0 Then gCurrent_time = 0.000002
                    If gEmulRA_Init = 0 Then gEmulRA_Init = gEmulRA
                    
                    If gLast_time > gCurrent_time Then      ' Counter wrap around ?
                        gLast_time = EQnow_lst_norange()
                        gCurrent_time = gLast_time
                        gEmulRA_Init = gEmulRA
                    End If
                    
                    
                    
                    ' Compute Elapste stepper count based on Elapsed Local Sidreal time (PC time)
                    
                    If gRA_LastRate = 0 Then
                        emulinc = gEMUL_RATE2 * (gCurrent_time - gLast_time)
                    Else  ' PEC tracking
                        emulinc = (gRightAscensionRate / gARCSECSTEP) * (gCurrent_time - gLast_time)
                        emulinc = (gCurrent_time - gLast_time) * gTot_RA / (1296000 / gRightAscensionRate)

                    End If
                    
                    
                    If gHemisphere = 0 Then
                        GetEmulRA = gEmulRA_Init + emulinc
                    Else
                        GetEmulRA = gEmulRA_Init - emulinc
                    End If

    Else
            
                    GetEmulRA = gEmulRA
    End If

End Function


Public Function GetEmulRA_EQ() As Double

Dim emulinc As Double
Dim tmpEmulRA As Double
Dim tmpgRA_Hours As Double

Dim tmpgRA_Encoder As Double
Dim tmpgDec_Encoder As Double

Dim tRA As Double
Dim tmpgDec_DegNoAdjust As Double


Dim tmpcoord As Coordt

                    'Compute for elapsed Time
            
        If gTrackingStatus = 1 Then
        
                    gCurrent_time = EQnow_lst_norange()
                    If gLast_time = 0 Then gCurrent_time = 0.000002
                    If gEmulRA_Init = 0 Then gEmulRA_Init = gEmulRA
                    
                    If gLast_time > gCurrent_time Then      ' Counter wrap around ?
                        gLast_time = EQnow_lst_norange()
                        gCurrent_time = gLast_time
                        gEmulRA_Init = gEmulRA
                    End If
                    
                    
                    
                    ' Compute Elapste stepper count based on Elapsed Local Sidreal time (PC time)
                    
                    If gRA_LastRate = 0 Then
                        emulinc = gEMUL_RATE2 * (gCurrent_time - gLast_time)
                    Else  ' PEC tracking
                        emulinc = (gRightAscensionRate / gARCSECSTEP) * (gCurrent_time - gLast_time)
                        emulinc = (gCurrent_time - gLast_time) * gTot_RA / (1296000 / gRightAscensionRate)

                    End If
                    
                    
                    If gHemisphere = 0 Then
                        tmpEmulRA = gEmulRA_Init + emulinc
                    Else
                        tmpEmulRA = gEmulRA_Init - emulinc
                    End If

            Else
                    tmpEmulRA = gEmulRA
            
            End If


           If gThreeStarEnable = False Then
                tmpgRA_Encoder = Delta_RA_Map(tmpEmulRA)
                tmpgDec_Encoder = Delta_DEC_Map(gEmulDEC)
            Else
            
                If HC.ListAlignMode.ListIndex = 2 Then
                
                    tmpcoord = DeltaSync_Matrix_Map(tmpEmulRA, gEmulDEC)
                    tmpgRA_Encoder = tmpcoord.x
                    tmpgDec_Encoder = tmpcoord.y

                Else
                    If HC.ListAlignMode.ListIndex = 1 Then
                        tmpcoord = Delta_Matrix_Reverse_Map(tmpEmulRA, gEmulDEC)
                        tmpgRA_Encoder = tmpcoord.x
                        tmpgDec_Encoder = tmpcoord.y
                    Else
                        tmpcoord = Delta_Matrix_Reverse_Map(tmpEmulRA, gEmulDEC)
                        tmpgRA_Encoder = tmpcoord.x
                        tmpgDec_Encoder = tmpcoord.y
                        
                        If tmpcoord.f = 0 Then
                        
                            tmpcoord = DeltaSync_Matrix_Map(tmpEmulRA, gEmulDEC)
                            tmpgRA_Encoder = tmpcoord.x
                            tmpgDec_Encoder = tmpcoord.y

                        End If
                        
                    End If
                
                End If
                
               
            End If
            
            If (tmpgRA_Encoder < &H1000000) Then tmpgRA_Hours = Get_EncoderHours(gRAEncoder_Zero_pos, tmpgRA_Encoder, gTot_RA, gHemisphere)

            tRA = EQnow_lst(gLongitude * DEG_RAD) + tmpgRA_Hours
            
            tmpgDec_DegNoAdjust = Get_EncoderDegrees(gDECEncoder_Zero_pos, tmpgDec_Encoder, gTot_DEC, gHemisphere)
          

        If gHemisphere = 0 Then
            If (tmpgDec_DegNoAdjust > 90) And (tmpgDec_DegNoAdjust <= 270) Then tRA = tRA - 12
        Else
            If (tmpgDec_DegNoAdjust <= 90) Or (tmpgDec_DegNoAdjust > 270) Then tRA = tRA + 12
        End If
    
        GetEmulRA_EQ = Range24(tRA)

End Function

Public Sub PlotInit()

Dim i As Integer

    HC.Plot_RA.DrawMode = 13
    HC.Plot_DEC.DrawMode = 13
    
    HC.Plot_RA.Cls
    HC.Plot_DEC.Cls
    
    HC.Plot_RA.Line (0, HC.Plot_RA.Height / 2)-(HC.Plot_RA.Width, HC.Plot_RA.Height / 2), vbBlue
    HC.Plot_DEC.Line (0, HC.Plot_DEC.Height / 2)-(HC.Plot_DEC.Width, HC.Plot_DEC.Height / 2), vbBlue

    gPlot_ra_pos = 0
    gPlot_dec_pos = 0
    
    gRAHeight = (HC.Plot_RA.Height / 2)
    gDecHeight = (HC.Plot_DEC.Height / 2)

    gplot_ra_cur = gRAHeight
    gPlot_dec_cur = gDecHeight
    
End Sub

Public Sub Plot_points(id As Integer, side As Integer, ppvalue As Long)
Dim pheight As Double
Dim pscale As Double
Dim pvalue As Double

    pvalue = ppvalue
    gMAX_RAlevel = HC.RAdisplay_gain.Value + 100
    gMAX_DEClevel = HC.DECdisplay_gain.Value + 100

    If id = 0 Then

        If gPlot_ra_pos > HC.Plot_RA.Width Then
            HC.Plot_RA.Cls
            HC.Plot_RA.Line (0, HC.Plot_RA.Height / 2)-(HC.Plot_RA.Width, HC.Plot_RA.Height / 2), vbBlue
            gPlot_ra_pos = 0
            gplot_ra_cur = gRAHeight
        End If
    
        If pvalue > gMAX_RAlevel Then pvalue = gMAX_RAlevel
    
        pscale = (pvalue / gMAX_RAlevel) * gRAHeight
    
        If side = 0 Then
                HC.Plot_RA.Line (gPlot_ra_pos, gplot_ra_cur)-(gPlot_ra_pos + (HC.Plot_RA.Width / gMAX_plotpoints), gRAHeight - pscale), vbRed
                gplot_ra_cur = gRAHeight - pscale
        Else
                HC.Plot_RA.Line (gPlot_ra_pos, gplot_ra_cur)-(gPlot_ra_pos + (HC.Plot_RA.Width / gMAX_plotpoints), gRAHeight + pscale), vbRed
                gplot_ra_cur = gRAHeight + pscale
        End If
        
        
        gPlot_ra_pos = gPlot_ra_pos + (HC.Plot_RA.Width / gMAX_plotpoints)
    Else
    
        If gPlot_dec_pos > HC.Plot_DEC.Width Then
            HC.Plot_DEC.Cls
            HC.Plot_DEC.Line (0, HC.Plot_DEC.Height / 2)-(HC.Plot_DEC.Width, HC.Plot_DEC.Height / 2), vbBlue
            gPlot_dec_pos = 0
            gPlot_dec_cur = gDecHeight
        End If
    
        If pvalue > gMAX_DEClevel Then pvalue = gMAX_DEClevel
    
        pscale = (pvalue / gMAX_DEClevel) * gDecHeight
    
        If gPlot_dec_pos <> 0 Then
            If side = 0 Then
                HC.Plot_DEC.Line (gPlot_dec_pos, gPlot_dec_cur)-(gPlot_dec_pos + (HC.Plot_DEC.Width / gMAX_plotpoints), gDecHeight - pscale), vbRed
                gPlot_dec_cur = gDecHeight - pscale
            Else
                HC.Plot_DEC.Line (gPlot_dec_pos, gPlot_dec_cur)-(gPlot_dec_pos + (HC.Plot_DEC.Width / gMAX_plotpoints), gDecHeight + pscale), vbRed
                gPlot_dec_cur = gDecHeight + pscale
            End If
        
        End If
        
        gPlot_dec_pos = gPlot_dec_pos + (HC.Plot_DEC.Width / gMAX_plotpoints)
    End If



End Sub


