Attribute VB_Name = "Alignment"
Option Explicit
'---------------------------------------------------------------------
' Copyright  2006 Raymund Sarmiento
'
' Permission is hereby granted to use this Software for any purpose
' including combining with commercial products, creating derivative
' works, and redistribution of source or binary code, without
' limitation or consideration. Any redistributed copies of this
' Software must include the above Copyright Notice.
'
' THIS SOFTWARE IS PROVIDED "AS IS". THE AUTHOR OF THIS CODE MAKES NO
' WARRANTIES REGARDING THIS SOFTWARE, EXPRESS OR IMPLIED, AS TO ITS
' SUITABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
'---------------------------------------------------------------------
'
' Common.bas - Common functions for EQMOD ASCOM driver
'
'
' Written:  07-Oct-06   Raymund Sarmiento
'
' Edits:
'
' When      Who     What
' --------- ---     --------------------------------------------------
' 12-Feb-07 sander  Created file, copied contents from common.bas
'                   including new datastructure for alignment data
' 19-Mar-07 rcs     Initial Edit for Three star alignment
' 08-Apr-07 rcs     N-star implementation
' 14-Jul-07         Use 1star even before 3 star is activated
'---------------------------------------------------------------------
'
'  SYNOPSIS:
'
'  This is a demonstration of a EQ6/ATLAS/EQG direct stepper motor control access
'  using the EQCONTRL.DLL driver code.
'
'  File EQCONTROL.bas contains all the function prototypes of all subroutines
'  encoded in the EQCONTRL.dll
'
'  The EQ6CONTRL.DLL simplifies execution of the Mount controller board stepper
'  commands.
'
'  The mount circuitry needs to be modified for this test program to work.
'  Circuit details can be found at http://www.freewebs.com/eq6mod/
'

'  DISCLAIMER:

'  You can use the information on this site COMPLETELY AT YOUR OWN RISK.
'  The modification steps and other information on this site is provided
'  to you "AS IS" and WITHOUT WARRANTY OF ANY KIND, express, statutory,
'  implied or otherwise, including without limitation any warranty of
'  merchantability or fitness for any particular or intended purpose.
'  In no event the author will  be liable for any direct, indirect,
'  punitive, special, incidental or consequential damages or loss of any
'  kind whether or not the author  has been advised of the possibility
'  of such loss.

'  WARNING:

'  Circuit modifications implemented on your setup could invalidate
'  any warranty that you may have with your product. Use this
'  information at your own risk. The modifications involve direct
'  access to the stepper motor controls of your mount. Any "mis-control"
'  or "mis-command"  / "invalid parameter" or "garbage" data sent to the
'  mount could accidentally activate the stepper motors and allow it to
'  rotate "freely" damaging any equipment connected to your mount.
'  It is also possible that any garbage or invalid data sent to the mount
'  could cause its firmware to generate mis-steps pulse sequences to the
'  motors causing it to overheat. Make sure that you perform the
'  modifications and testing while there is no physical "load" or
'  dangling wires on your mount. Be sure to disconnect the power once
'  this event happens or if you notice any unusual sound coming from
'  the motor assembly.
'
'  CREDITS:
'
'  Portions of the information on this code should be attributed
'  to Mr. John Archbold from his initial observations and analysis
'  of the interface circuits and of the ASCII data stream between
'  the Hand Controller (HC) and the Go To Controller.



Public Const MAX_STARS As Integer = 1000

Public gThreeStarEnable As Boolean
Public gSelectStar As Long


Public gRA_GOTO As Double
Public gDEC_GOTO As Double


Public Type AlignmentData
    OrigTargetRA As Double
    OrigTargetDEC As Double
    TargetRA    As Double
    TargetDEC   As Double
    EncoderRA   As Double
    EncoderDEC  As Double
    AlignTime   As Date
End Type

Public Enum AlignmentType
    OneStar = 1
    ThreeStar = 3
End Enum

Public gAlignmentStars_count As Integer

Public AlignmentStars(MAX_STARS) As AlignmentData

Public ct_Points(1 To MAX_STARS) As Coord  'Catalog Points
Public my_Points(1 To MAX_STARS) As Coord   'My Measured Points


Public Sub ThreeStarAlign()

Dim i As Integer
    
    HC.Add_Message_Align ("---------------------------")
    HC.Add_Message_Align (HC.oLangDll.GetLangString(6000))
    HC.Add_Message_Align (HC.oLangDll.GetLangString(105) & ":" & Format$(Str(gRA1Star), "000000000") & " " & HC.oLangDll.GetLangString(106) & ":" & Format$(Str(gDEC1Star), "000000000"))
    HC.Add_Message_Align (HC.oLangDll.GetLangString(6001))
    HC.Add_Message_Align (HC.oLangDll.GetLangString(105) & "(1):" & Format$(Str(AlignmentStars(1).TargetRA - AlignmentStars(1).EncoderRA), "000000000") & " " & HC.oLangDll.GetLangString(106) & "(1):" & Format$(Str(AlignmentStars(1).TargetDEC - AlignmentStars(1).EncoderDEC), "000000000"))
    HC.Add_Message_Align (HC.oLangDll.GetLangString(105) & "(2):" & Format$(Str(AlignmentStars(2).TargetRA - AlignmentStars(2).EncoderRA), "000000000") & " " & HC.oLangDll.GetLangString(106) & "(2):" & Format$(Str(AlignmentStars(2).TargetDEC - AlignmentStars(2).EncoderDEC), "000000000"))
    HC.Add_Message_Align (HC.oLangDll.GetLangString(105) & "(3):" & Format$(Str(AlignmentStars(3).TargetRA - AlignmentStars(3).EncoderRA), "000000000") & " " & HC.oLangDll.GetLangString(106) & "(3):" & Format$(Str(AlignmentStars(3).TargetDEC - AlignmentStars(3).EncoderDEC), "000000000"))
  

    ' Assemble the Matrix
    
    For i = 1 To 3
    
        ct_Points(i).x = AlignmentStars(i).TargetRA
        ct_Points(i).y = AlignmentStars(i).TargetDEC
        ct_Points(i).z = 1
    
        my_Points(i).x = AlignmentStars(i).EncoderRA
        my_Points(i).y = AlignmentStars(i).EncoderDEC
        my_Points(i).z = 1
    
    Next i

    i = EQ_AssembleMatrix_Taki(0, 0, EQ_sp2Cs(ct_Points(1)), EQ_sp2Cs(ct_Points(2)), EQ_sp2Cs(ct_Points(3)), EQ_sp2Cs(my_Points(1)), EQ_sp2Cs(my_Points(2)), EQ_sp2Cs(my_Points(3)))
    i = EQ_AssembleMatrix_Affine(0, 0, EQ_sp2Cs(my_Points(1)), EQ_sp2Cs(my_Points(2)), EQ_sp2Cs(my_Points(3)), EQ_sp2Cs(ct_Points(1)), EQ_sp2Cs(ct_Points(2)), EQ_sp2Cs(ct_Points(3)))

    gAlignmentStars_count = 3
  
    gThreeStarEnable = True
    

End Sub

Public Sub OneStarAlign()

Dim targetRAEncoder As Double
Dim targetDECEncoder As Double
Dim currentRAEncoder As Double
Dim currentDECEncoder As Double


    currentRAEncoder = AlignmentStars(1).EncoderRA
    currentDECEncoder = AlignmentStars(1).EncoderDEC
    targetRAEncoder = AlignmentStars(1).TargetRA
    targetDECEncoder = AlignmentStars(1).TargetDEC
    
    gAlignmentStars_count = 1
          
    gRA1Star = targetRAEncoder - currentRAEncoder
    gDEC1Star = targetDECEncoder - currentDECEncoder
    Call resetsync  ' Sync data will now be invalid at this point
     
    Call WriteAlignMap
    
    
    HC.Add_Message_Align ("---------------------------")
    HC.Add_Message_Align (HC.oLangDll.GetLangString(6000))
    HC.Add_Message_Align (HC.oLangDll.GetLangString(105) & ":" & Format$(Str(gRA1Star), "000000000") & " " & HC.oLangDll.GetLangString(106) & ":" & Format$(Str(gDEC1Star), "000000000"))
    HC.Add_Message_Align (HC.oLangDll.GetLangString(6002))
     
End Sub

Public Sub MoreStarAlign()

Dim i As Integer

    HC.Add_Message_Align ("---------------------------")
    HC.Add_Message_Align (HC.oLangDll.GetLangString(6000))
    HC.Add_Message_Align (HC.oLangDll.GetLangString(105) & ":" & Format$(Str(gRA1Star), "000000000") & " " & HC.oLangDll.GetLangString(106) & ":" & Format$(Str(gDEC1Star), "000000000"))
    HC.Add_Message_Align (HC.oLangDll.GetLangString(6001))

    For i = 1 To (Align.CurrentAlignmentStar - 1)
    
        ct_Points(i).x = AlignmentStars(i).TargetRA
        ct_Points(i).y = AlignmentStars(i).TargetDEC
        ct_Points(i).z = 1
    
        my_Points(i).x = AlignmentStars(i).EncoderRA
        my_Points(i).y = AlignmentStars(i).EncoderDEC
        my_Points(i).z = 1
    
        HC.Add_Message_Align (HC.oLangDll.GetLangString(105) & " (" & Str(i) & "):" & Format$(Str(AlignmentStars(i).TargetRA - AlignmentStars(i).EncoderRA), "000000000") & "  " & HC.oLangDll.GetLangString(106) & Str(i) & "):" & Format$(Str(AlignmentStars(i).TargetDEC - AlignmentStars(i).EncoderDEC), "000000000"))
    Next i

    gAlignmentStars_count = Align.CurrentAlignmentStar - 1
    
End Sub

Public Sub EQ_AlignViaSync(ByVal RightAscension As Double, ByVal Declination As Double, ByVal pLongitude As Double, ByVal pHemisphere As Long)

Dim tRA As Double
Dim tha As Double
Dim tPier As Double
Dim vRA As Double
Dim vDEC As Double

Dim deltaRA As Double
Dim deltadec As Double

Dim curalign As Long
Dim i As Long


    If gSlewStatus = True Then
        HC.Add_Message_Align (HC.oLangDll.GetLangString(5027))
        Exit Sub
    End If
    
    If Align.Visible = True Then
        HC.Add_Message_Align (HC.oLangDll.GetLangString(6003))
        Exit Sub
    End If

    curalign = gAlignmentStars_count + 1

    HC.EncoderTimer.Enabled = False
    With AlignmentStars(curalign)
    
        vRA = RightAscension
        vDEC = Declination
        
        tha = RangeHA(vRA - EQnow_lst(pLongitude * DEG_RAD))
  
        If tha < 0 Then
        
            If pHemisphere = 0 Then
                tPier = 1
            Else
                tPier = 0
            End If
        
            tRA = Range24(vRA - 12)
    
        Else
        
            If pHemisphere = 0 Then
                tPier = 0
            Else
                tPier = 1
            End If
        
            tRA = vRA
    
        End If

        'Compute for Sync RA/DEC Encoder Values

        .OrigTargetDEC = Declination
        .OrigTargetRA = RightAscension
        .TargetRA = Get_RAEncoderfromRA(tRA, 0, pLongitude, gRAEncoder_Zero_pos, gTot_RA, pHemisphere)
        .TargetDEC = Get_DECEncoderfromDEC(vDEC, tPier, gDECEncoder_Zero_pos, gTot_DEC, pHemisphere)

        .EncoderRA = EQ_GetMotorValues(0)
        .EncoderDEC = EQ_GetMotorValues(1)
        .AlignTime = Now
        
        deltaRA = Abs(.TargetRA - .EncoderRA)
        deltadec = Abs(.TargetDEC - .EncoderDEC)
        
        
    End With
    
    HC.EncoderTimer.Enabled = True
    
    If (deltaRA < gEQ_MAXSYNC) And (deltadec < gEQ_MAXSYNC) Then
        If curalign < 3 Then
            HC.Add_Message_Align (Str(curalign) & " " & HC.oLangDll.GetLangString(6009))
            gAlignmentStars_count = gAlignmentStars_count + 1
        Else
            If curalign = 3 Then
                Call ThreeStarAlign
            Else
            
                HC.Add_Message_Align ("---------------------------")
                HC.Add_Message_Align (HC.oLangDll.GetLangString(6000))
                HC.Add_Message_Align (HC.oLangDll.GetLangString(105) & ":" & Format$(Str(gRA1Star), "000000000") & " " & HC.oLangDll.GetLangString(106) & ":" & Format$(Str(gDEC1Star), "000000000"))
                HC.Add_Message_Align (HC.oLangDll.GetLangString(6001))

                For i = 1 To curalign
    
                    ct_Points(i).x = AlignmentStars(i).TargetRA
                    ct_Points(i).y = AlignmentStars(i).TargetDEC
                    ct_Points(i).z = 1
    
                    my_Points(i).x = AlignmentStars(i).EncoderRA
                    my_Points(i).y = AlignmentStars(i).EncoderDEC
                    my_Points(i).z = 1
                    
                    HC.Add_Message_Align (HC.oLangDll.GetLangString(105) & " (" & Str(i) & "):" & Format$(Str(AlignmentStars(i).TargetRA - AlignmentStars(i).EncoderRA), "000000000") & "  " & HC.oLangDll.GetLangString(106) & "(" & Str(i) & "):" & Format$(Str(AlignmentStars(i).TargetDEC - AlignmentStars(i).EncoderDEC), "000000000"))

                Next i

                gAlignmentStars_count = curalign
            
            End If
        End If
    Else
        HC.Add_Message_Align (HC.oLangDll.GetLangString(6004))
    End If
    
End Sub

Public Sub SendtoMatrix(curalign As Integer)

Dim i As Integer

    HC.Add_Message_Align ("---------------------------")
    HC.Add_Message_Align (HC.oLangDll.GetLangString(6000))
    HC.Add_Message_Align (HC.oLangDll.GetLangString(105) & ":" & Format$(Str(gRA1Star), "000000000") & " " & HC.oLangDll.GetLangString(106) & ":" & Format$(Str(gDEC1Star), "000000000"))
    HC.Add_Message_Align (HC.oLangDll.GetLangString(6001))

    For i = 1 To curalign
    
       ct_Points(i).x = AlignmentStars(i).TargetRA
       ct_Points(i).y = AlignmentStars(i).TargetDEC
       ct_Points(i).z = 1
    
       my_Points(i).x = AlignmentStars(i).EncoderRA
       my_Points(i).y = AlignmentStars(i).EncoderDEC
       my_Points(i).z = 1
                    
       HC.Add_Message_Align (HC.oLangDll.GetLangString(106) & " (" & Str(i) & "):" & Format$(Str(AlignmentStars(i).TargetRA - AlignmentStars(i).EncoderRA), "000000000") & "  " & HC.oLangDll.GetLangString(106) & "(" & Str(i) & "):" & Format$(Str(AlignmentStars(i).TargetDEC - AlignmentStars(i).EncoderDEC), "000000000"))

    Next i

    'Activate Matrix here
    
    HC.EncoderTimer.Enabled = False
    
    If HC.PolarEnable.Value = 1 Then
        If (curalign >= 3) Then
            i = EQ_AssembleMatrix_Taki(0, 0, EQ_sp2Cs(ct_Points(1)), EQ_sp2Cs(ct_Points(2)), EQ_sp2Cs(ct_Points(3)), EQ_sp2Cs(my_Points(1)), EQ_sp2Cs(my_Points(2)), EQ_sp2Cs(my_Points(3)))
            i = EQ_AssembleMatrix_Affine(0, 0, EQ_sp2Cs(my_Points(1)), EQ_sp2Cs(my_Points(2)), EQ_sp2Cs(my_Points(3)), EQ_sp2Cs(ct_Points(1)), EQ_sp2Cs(ct_Points(2)), EQ_sp2Cs(ct_Points(3)))
            gThreeStarEnable = True
        End If
    Else
        If (curalign >= 3) Then
            i = EQ_AssembleMatrix_Taki(0, 0, EQ_sp2Cs(ct_Points(1)), EQ_sp2Cs(ct_Points(2)), EQ_sp2Cs(ct_Points(3)), EQ_sp2Cs(my_Points(1)), EQ_sp2Cs(my_Points(2)), EQ_sp2Cs(my_Points(3)))
            i = EQ_AssembleMatrix_Affine(0, 0, EQ_sp2Cs(my_Points(1)), EQ_sp2Cs(my_Points(2)), EQ_sp2Cs(my_Points(3)), EQ_sp2Cs(ct_Points(1)), EQ_sp2Cs(ct_Points(2)), EQ_sp2Cs(ct_Points(3)))
            gThreeStarEnable = True
        End If
    End If
    
    HC.EncoderTimer.Enabled = True


End Sub

