VERSION 5.00
Begin VB.Form Align 
   BackColor       =   &H00000000&
   BorderStyle     =   4  'Fixed ToolWindow
   Caption         =   "Alignment"
   ClientHeight    =   7440
   ClientLeft      =   45
   ClientTop       =   315
   ClientWidth     =   4065
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   7440
   ScaleWidth      =   4065
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton Command4 
      Caption         =   "E"
      BeginProperty Font 
         Name            =   "Arial Black"
         Size            =   36
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1215
      Left            =   2760
      TabIndex        =   4
      Top             =   3120
      Width           =   1215
   End
   Begin VB.CommandButton Command2 
      Caption         =   "S"
      BeginProperty Font 
         Name            =   "Arial Black"
         Size            =   36
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1020
      Left            =   1440
      TabIndex        =   3
      Top             =   4440
      Width           =   1215
   End
   Begin VB.CommandButton End_Command 
      BackColor       =   &H8000000C&
      Caption         =   "END"
      Enabled         =   0   'False
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   11.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   1440
      TabIndex        =   22
      Top             =   3840
      Width           =   1215
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   100
      Left            =   3480
      Top             =   120
   End
   Begin VB.CommandButton Command7 
      Caption         =   "PAD"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   465
      Left            =   120
      TabIndex        =   15
      Top             =   4440
      Width           =   855
   End
   Begin VB.HScrollBar HScroll2 
      Height          =   255
      Left            =   120
      Max             =   800
      Min             =   1
      TabIndex        =   9
      Top             =   6240
      Value           =   400
      Width           =   2775
   End
   Begin VB.HScrollBar HScroll1 
      Height          =   255
      Left            =   120
      Max             =   800
      Min             =   1
      TabIndex        =   8
      Top             =   5640
      Value           =   400
      Width           =   2775
   End
   Begin VB.CommandButton Accept_Command 
      Caption         =   "Accept"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   11.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   615
      Left            =   1440
      TabIndex        =   5
      Top             =   3120
      Width           =   1215
   End
   Begin VB.CommandButton Command1 
      Caption         =   "W"
      BeginProperty Font 
         Name            =   "Arial Black"
         Size            =   36
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1185
      Left            =   120
      TabIndex        =   2
      Top             =   3120
      Width           =   1215
   End
   Begin VB.CommandButton Abort_Command 
      Caption         =   "ABORT"
      BeginProperty Font 
         Name            =   "Arial Black"
         Size            =   15.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   615
      Left            =   120
      TabIndex        =   1
      Top             =   6720
      Width           =   3735
   End
   Begin VB.CommandButton Command3 
      Caption         =   "N"
      BeginProperty Font 
         Name            =   "Arial Black"
         Size            =   36
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1140
      Left            =   1440
      TabIndex        =   0
      Top             =   1920
      Width           =   1215
   End
   Begin VB.Label RA_Target 
      BackColor       =   &H00000080&
      BeginProperty Font 
         Name            =   "Arial Narrow"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   255
      Left            =   1440
      TabIndex        =   21
      Top             =   1080
      Width           =   1215
   End
   Begin VB.Label RA_Tgt_Label 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00000000&
      Caption         =   "RA Target"
      ForeColor       =   &H000080FF&
      Height          =   255
      Left            =   120
      TabIndex        =   20
      Top             =   1080
      Width           =   1215
   End
   Begin VB.Label Dec_Target 
      BackColor       =   &H00000080&
      BeginProperty Font 
         Name            =   "Arial Narrow"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   255
      Left            =   1440
      TabIndex        =   19
      Top             =   1320
      Width           =   1215
   End
   Begin VB.Label Star_TextLabel 
      BackColor       =   &H00000080&
      BeginProperty Font 
         Name            =   "Arial Narrow"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   255
      Left            =   1440
      TabIndex        =   16
      Top             =   1560
      Width           =   1215
   End
   Begin VB.Label Label6 
      BackColor       =   &H00000000&
      Caption         =   "EQMOD ALIGNMENT TOOL"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000080FF&
      Height          =   375
      Left            =   120
      TabIndex        =   14
      Top             =   120
      Width           =   4215
   End
   Begin VB.Label Label5 
      BackColor       =   &H00000000&
      Caption         =   "DEC Slew Rate"
      ForeColor       =   &H000080FF&
      Height          =   255
      Left            =   120
      TabIndex        =   13
      Top             =   6000
      Width           =   2055
   End
   Begin VB.Label Label4 
      BackColor       =   &H00000000&
      Caption         =   "RA Slew Rate"
      ForeColor       =   &H000080FF&
      Height          =   255
      Left            =   120
      TabIndex        =   12
      Top             =   5400
      Width           =   1935
   End
   Begin VB.Label Label3 
      BackColor       =   &H00000080&
      Caption         =   "400"
      BeginProperty Font 
         Name            =   "Arial Narrow"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   255
      Left            =   3000
      TabIndex        =   11
      Top             =   6240
      Width           =   855
   End
   Begin VB.Label Label2 
      BackColor       =   &H00000080&
      Caption         =   "400"
      BeginProperty Font 
         Name            =   "Arial Narrow"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   255
      Left            =   3000
      TabIndex        =   10
      Top             =   5640
      Width           =   855
   End
   Begin VB.Label SecondLabel 
      BackColor       =   &H00000080&
      BeginProperty Font 
         Name            =   "Arial Narrow"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   255
      Left            =   120
      TabIndex        =   7
      Top             =   840
      Width           =   3855
   End
   Begin VB.Label MainLabel 
      BackColor       =   &H00000080&
      BeginProperty Font 
         Name            =   "Arial Narrow"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   255
      Left            =   120
      TabIndex        =   6
      Top             =   600
      Width           =   3855
   End
   Begin VB.Label Star_Label 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00000000&
      Caption         =   "Alignmnt. star"
      ForeColor       =   &H000080FF&
      Height          =   255
      Left            =   120
      TabIndex        =   17
      Top             =   1560
      Width           =   1215
   End
   Begin VB.Label DEC_Tgt_Label 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00000000&
      Caption         =   "DEC Target"
      ForeColor       =   &H000080FF&
      Height          =   255
      Left            =   120
      TabIndex        =   18
      Top             =   1320
      Width           =   1215
   End
End
Attribute VB_Name = "Align"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'---------------------------------------------------------------------
' Copyright  2006 Raymund Sarmiento
'
' Permission is hereby granted to use this Software for any purpose
' including combining with commercial products, creating derivative
' works, and redistribution of source or binary code, without
' limitation or consideration. Any redistributed copies of this
' Software must include the above Copyright Notice.
'
' THIS SOFTWARE IS PROVIDED "AS IS". THE AUTHOR OF THIS CODE MAKES NO
' WARRANTIES REGARDING THIS SOFTWARE, EXPRESS OR IMPLIED, AS TO ITS
' SUITABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
'---------------------------------------------------------------------
'
' Align.frm - 1 Star alignment form
'
' Written:  07-Oct-06   Raymund Sarmiento
'
' Edits:
'
' When      Who     What
' --------- ---     --------------------------------------------------
' 04-Nov-06 rcs     Initial edit for EQ Mount Driver Function Prototype
' 05-Jan-07 rcs     Added Joystick Button Accept/Abort
' 06-May-07 rcs     Added Gamepad accept on N-Star Align
' 26-Jul-07 cs      Gamepad accept/cancel user 'variable' button definition
' 30-Jul-07 cs      Gamepad alignment end handling
'---------------------------------------------------------------------
'
'
'  SYNOPSIS:
'
'  This is a demonstration of a EQ6/ATLAS/EQG direct stepper motor control access
'  using the EQCONTRL.DLL driver code.
'
'  File EQCONTROL.bas contains all the function prototypes of all subroutines
'  encoded in the EQCONTRL.dll
'
'  The EQ6CONTRL.DLL simplifies execution of the Mount controller board stepper
'  commands.
'
'  The mount circuitry needs to be modified for this test program to work.
'  Circuit details can be found at http://www.freewebs.com/eq6mod/
'

'  DISCLAIMER:

'  You can use the information on this site COMPLETELY AT YOUR OWN RISK.
'  The modification steps and other information on this site is provided
'  to you "AS IS" and WITHOUT WARRANTY OF ANY KIND, express, statutory,
'  implied or otherwise, including without limitation any warranty of
'  merchantability or fitness for any particular or intended purpose.
'  In no event the author will  be liable for any direct, indirect,
'  punitive, special, incidental or consequential damages or loss of any
'  kind whether or not the author  has been advised of the possibility
'  of such loss.

'  WARNING:

'  Circuit modifications implemented on your setup could invalidate
'  any warranty that you may have with your product. Use this
'  information at your own risk. The modifications involve direct
'  access to the stepper motor controls of your mount. Any "mis-control"
'  or "mis-command"  / "invalid parameter" or "garbage" data sent to the
'  mount could accidentally activate the stepper motors and allow it to
'  rotate "freely" damaging any equipment connected to your mount.
'  It is also possible that any garbage or invalid data sent to the mount
'  could cause its firmware to generate mis-steps pulse sequences to the
'  motors causing it to overheat. Make sure that you perform the
'  modifications and testing while there is no physical "load" or
'  dangling wires on your mount. Be sure to disconnect the power once
'  this event happens or if you notice any unusual sound coming from
'  the motor assembly.
'
'  CREDITS:
'
'  Portions of the information on this code should be attributed
'  to Mr. John Archbold from his initial observations and analysis
'  of the interface circuits and of the ASCII data stream between
'  the Hand Controller (HC) and the Go To Controller.
'

Option Explicit

Private aUtil As DriverHelper.Util
Public CurrentAlignmentStar As Integer
Private AlignmentMethod As AlignmentType


Private Sub Command1_MouseDown(Button As Integer, Shift As Integer, x As Single, Y As Single)
    
    If gEQparkstatus = 1 Then
            HC.Add_Message (HC.oLangDll.GetLangString(5000))
            Exit Sub
    End If
    
    Call West_Down(val(HScroll1.Value))
    HC.Add_Message (HC.oLangDll.GetLangString(5010))
End Sub

Private Sub Command1_MouseUp(Button As Integer, Shift As Integer, x As Single, Y As Single)
   
   Call West_Up
   
End Sub

Private Sub Command2_MouseDown(Button As Integer, Shift As Integer, x As Single, Y As Single)
    If gEQparkstatus = 1 Then
            HC.Add_Message (HC.oLangDll.GetLangString(5000))
            Exit Sub
    End If
    
    Call South_Down(val(HScroll2.Value))
    HC.Add_Message (HC.oLangDll.GetLangString(5011))
End Sub

Private Sub Command2_MouseUp(Button As Integer, Shift As Integer, x As Single, Y As Single)
    Call South_Up
    
End Sub

Private Sub Command3_MouseDown(Button As Integer, Shift As Integer, x As Single, Y As Single)
    
    If gEQparkstatus = 1 Then
            HC.Add_Message (HC.oLangDll.GetLangString(5000))
            Exit Sub
    End If
        
    Call North_Down(val(HScroll2.Value))
    HC.Add_Message (HC.oLangDll.GetLangString(5001))

End Sub

Private Sub Command3_MouseUp(Button As Integer, Shift As Integer, x As Single, Y As Single)
    Call North_Up
End Sub



Private Sub Command4_MouseDown(Button As Integer, Shift As Integer, x As Single, Y As Single)
  
   If gEQparkstatus = 1 Then
            HC.Add_Message (HC.oLangDll.GetLangString(5000))
            Exit Sub
   End If
  
   Call East_Down(val(HScroll1.Value))
   HC.Add_Message (HC.oLangDll.GetLangString(5009))
   
End Sub

Private Sub Command4_MouseUp(Button As Integer, Shift As Integer, x As Single, Y As Single)
    
    Call East_Up
    
End Sub

Private Sub Accept_Command_Click()

    Call AcceptClick

End Sub

Private Sub End_Command_Click()


        Align.Timer1.Enabled = False
        HC.Add_Message (HC.oLangDll.GetLangString(5022) & Str(gAlignmentStars_count))
        
        'activate them all here
        
        Call MoreStarAlign
        
        writeratebarstateAlign
        Unload Align
        
End Sub

Private Sub Abort_Command_Click()
    Align.Timer1.Enabled = False
    HC.Add_Message (HC.oLangDll.GetLangString(5023))
    writeratebarstateAlign
    HC.OneStar_Command.Enabled = True
    HC.ThreeStar_Command.Enabled = True
    Unload Align
End Sub

Private Sub Command7_Click()
    Load Slewpad
    Slewpad.Show
End Sub

Private Sub Form_Load()

    Call SetText

    If HC.HCOnTop.Value = 1 Then Call PutWindowOnTop(Align)

    End_Command.Enabled = False
    gEQjbuttons = 0
    Align.Timer1.Enabled = True
   
    EnableCloseButton Me.hWnd, False
    Set aUtil = New DriverHelper.Util
    readratebarstateAlign
    Accept_Command.Enabled = False
    SecondLabel.Caption = HC.oLangDll.GetLangString(508)
    If gAlignmentStars_count >= 3 Then
        End_Command.Enabled = True
    Else
        End_Command.Enabled = False
    End If

    gJoyTimerFlag2 = True
    
End Sub

Private Sub HScroll1_Change()
    Label2.Caption = HScroll1.Value
End Sub

Private Sub HScroll1_Scroll()
    Label2.Caption = HScroll1.Value
End Sub

Private Sub HScroll2_Change()
    Label3.Caption = HScroll2.Value
End Sub

Private Sub HScroll2_Scroll()
    Label3.Caption = HScroll2.Value
End Sub




Private Sub Timer1_Timer()


  If gJoyTimerFlag2 = True Then         ' Avoid Overruns

    gJoyTimerFlag2 = False
    
    If (gEQjbuttons And BTN_ALIGNACCEPT) Then ' Accept

'        Align.Timer1.Enabled = False
'        Call OneStarAlign
'        writeratebarstateAlign
'        Unload Align

        If Accept_Command.Enabled = True Then
            gEQjbuttons = 0
            Call AcceptClick
        End If

    End If
    
    If (gEQjbuttons And BTN_ALIGNCANCEL) Then ' Abort
        gEQjbuttons = 0
        Align.Timer1.Enabled = False
        writeratebarstateAlign
        HC.Add_Message (HC.oLangDll.GetLangString(5023))
        Unload Align
    End If

    If (gEQjbuttons And BTN_ALIGNEND) Then ' End
        gEQjbuttons = 0
        Call End_Command_Click
    End If

    gJoyTimerFlag2 = True
    
  End If

End Sub
Private Sub SetAlignmentStar(Star As Integer)
    CurrentAlignmentStar = Star
    If Star > 3 Then
        Star_TextLabel = CurrentAlignmentStar & " / N"
    Else
        Star_TextLabel = CurrentAlignmentStar & " / " & AlignmentMethod
    End If
    RA_Target = ""
    Dec_Target = ""
End Sub
Public Sub FillAlignmentStar(ra As Double, DEC As Double)

    HC.Add_Message (HC.oLangDll.GetLangString(5024) & " " & HC.oLangDll.GetLangString(105) & "[ " & FmtSexa(ra, False) & " ] " & HC.oLangDll.GetLangString(106) & "[ " & FmtSexa(DEC, True) & " ]")
    
    gRA_GOTO = ra
    gDEC_GOTO = DEC

    RA_Target = ra
    Dec_Target = DEC
    
    With AlignmentStars(CurrentAlignmentStar)
        .OrigTargetDEC = DEC
        .OrigTargetRA = ra
    End With
    
    SecondLabel = HC.oLangDll.GetLangString(5025)
    Accept_Command.Enabled = True
    
End Sub

Public Sub SetAlignmentMethod(Method As AlignmentType)
    AlignmentMethod = Method
    Select Case Method
    Case OneStar
        MainLabel.Caption = HC.oLangDll.GetLangString(5026)
        SetAlignmentStar (1)
    Case ThreeStar
        MainLabel.Caption = HC.oLangDll.GetLangString(5027)
        If gAlignmentStars_count <= 1 Then
            SetAlignmentStar (1)
        Else
            SetAlignmentStar (gAlignmentStars_count + 1)
        End If
    End Select
    
End Sub

Public Sub AcceptClick()
Dim tRA As Double
Dim tha As Double
Dim tPier As Double
Dim vRA As Double
Dim vDEC As Double

Dim deltaRA As Double
Dim deltadec As Double

    If gSlewStatus = True Then
        
        SecondLabel = HC.oLangDll.GetLangString(5028)
        Exit Sub
    End If

    Align.Timer1.Enabled = False
    HC.EncoderTimer.Enabled = False
    With AlignmentStars(CurrentAlignmentStar)
    
        vRA = gRA_GOTO
        vDEC = gDEC_GOTO
        
        tha = RangeHA(vRA - EQnow_lst(gLongitude * DEG_RAD))
  
        If tha < 0 Then
        
            If gHemisphere = 0 Then
                tPier = 1
            Else
                tPier = 0
            End If
        
            tRA = Range24(vRA - 12)
    
        Else
        
            If gHemisphere = 0 Then
                tPier = 0
            Else
                tPier = 1
            End If
        
            tRA = vRA
    
        End If

        'Compute for Sync RA/DEC Encoder Values

        .TargetRA = Get_RAEncoderfromRA(tRA, 0, gLongitude, gRAEncoder_Zero_pos, gTot_RA, gHemisphere)
        .TargetDEC = Get_DECEncoderfromDEC(vDEC, tPier, gDECEncoder_Zero_pos, gTot_DEC, gHemisphere)

        .EncoderRA = EQ_GetMotorValues(0)
        .EncoderDEC = EQ_GetMotorValues(1)
        .AlignTime = Now
        
        deltaRA = Abs(.TargetRA - .EncoderRA)
        deltadec = Abs(.TargetDEC - .EncoderDEC)
        
    ' Use this data also for next gotos until a three star is achieved
    
        gRA1Star = .TargetRA - .EncoderRA
        gDEC1Star = .TargetDEC - .EncoderDEC
        
        
    End With
    
    HC.EncoderTimer.Enabled = True
    
    If (deltaRA < gEQ_MAXSYNC) And (deltadec < gEQ_MAXSYNC) Then
      If CurrentAlignmentStar = AlignmentMethod Then
        Select Case AlignmentMethod
        Case OneStar
            Call OneStarAlign
            Unload Align
        Case ThreeStar
 
            Call ThreeStarAlign
            End_Command.Enabled = True
            Accept_Command.Enabled = False
            End_Command.Enabled = True
            SecondLabel = HC.oLangDll.GetLangString(5029)
            SetAlignmentStar (CurrentAlignmentStar + 1)
            writeratebarstateAlign
        End Select
     Else
        ' need to do more stars, pop to the next and disable the accept button
        
        SecondLabel = HC.oLangDll.GetLangString(5030)
        SetAlignmentStar (CurrentAlignmentStar + 1)
        Accept_Command.Enabled = False
        writeratebarstateAlign
        
     End If
    Else
        SecondLabel = HC.oLangDll.GetLangString(5031)
        Accept_Command.Enabled = False
    End If
    
    Call EQ_Beep
    
    Align.Timer1.Enabled = True

End Sub


Private Sub SetText()
    Align.Caption = HC.oLangDll.GetLangString(507)
    Label6.Caption = HC.oLangDll.GetLangString(500)
    RA_Tgt_Label.Caption = HC.oLangDll.GetLangString(501)
    DEC_Tgt_Label.Caption = HC.oLangDll.GetLangString(502)
    Star_Label.Caption = HC.oLangDll.GetLangString(503)
    Command1.Caption = HC.oLangDll.GetLangString(115)
    Command2.Caption = HC.oLangDll.GetLangString(116)
    Command3.Caption = HC.oLangDll.GetLangString(113)
    Command4.Caption = HC.oLangDll.GetLangString(114)
    Command7.Caption = HC.oLangDll.GetLangString(112)
    Label4.Caption = HC.oLangDll.GetLangString(117)
    Accept_Command.Caption = HC.oLangDll.GetLangString(504)
    End_Command.Caption = HC.oLangDll.GetLangString(505)
    Abort_Command.Caption = HC.oLangDll.GetLangString(506)
    Label5.Caption = HC.oLangDll.GetLangString(118)
End Sub
